/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.security;

import de.vw.vaudes.diaghook.activator.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public final class SecurityComponent {
    private static final Log LOGGER = LogFactory.getLog(SecurityComponent.class);
    private static SecurityComponent fSecComp = new SecurityComponent();
    private Signature fSigner;

    public static SecurityComponent getInstance() {
        return fSecComp;
    }

    private SecurityComponent() {
        this.initSigner();
    }

    private void initSigner() {
        try {
            byte[] byArray = this.loadKeymaterial("sig_pub_sun.rsa");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            this.fSigner = Signature.getInstance("SHA256withRSA", "SunRsaSign");
            this.fSigner.initVerify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.error((Object)invalidKeyException);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.error((Object)noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            LOGGER.error((Object)noSuchProviderException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOGGER.error((Object)invalidKeySpecException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadKeymaterial(String string) throws IOException {
        Object object;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        byte[] byArray = null;
        try {
            long l;
            object = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(string), (Map)Collections.EMPTY_MAP);
            if (null == object) {
                throw new IllegalStateException(string + " not found");
            }
            File file = new File(FileLocator.toFileURL((URL)object).getFile());
            if (file.exists() && file.isFile()) {
                l = file.length();
                if (l > Integer.MAX_VALUE) {
                    throw new IllegalStateException("File:" + file.getName() + " is too large!");
                }
            } else {
                throw new IllegalStateException(string + " not found");
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file.getPath());
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
            byArray = IOUtils.toByteArray((Reader)inputStreamReader, (Charset)Charset.forName("UTF-8"));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((Reader)inputStreamReader);
        object = DatatypeConverter.parseBase64Binary((String)new String(byArray, Charset.forName("UTF-8")));
        return object;
    }

    public Signature getSig() {
        return this.fSigner;
    }
}

