/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IRequiredVersion;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IStartEndModule;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.ITestProgram;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.ITestProgramReference;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factory.ITestProgramFactory;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.index.fkc.FkcMetaData;
import de.vw.vaudes.diaghook.index.fkc.FunctiontestIndicator;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.TestProgramTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.Pair;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.stringtable.VAUDESStringTabelle;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TestProgramFactoryImpl
implements ITestProgramFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public List<ITestProgramReference> getTestProgramReferences(String string, List<ITestProgramReference> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTestProgramReferences(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<ITestProgramReference>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(TestProgramTransformHelper.getTestProgramReferencesFromDiagnosticObject(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            return list;
        }
    }

    public SortedSet<IStartEndModule> getStartEndModulesByType(String string, int n, SortedSet<IStartEndModule> sortedSet) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getStartEndModulesByType(" + string + ", " + n + ", " + sortedSet + ")"));
        }
        if (null == sortedSet) {
            sortedSet = new TreeSet<IStartEndModule>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return sortedSet;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            sortedSet.clear();
            sortedSet.addAll(TestProgramTransformHelper.getKnowledgebaseModulsByType(vAUDESObjekt, n));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + sortedSet));
            }
            return sortedSet;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            return sortedSet;
        }
    }

    public List<IRequiredVersion> getRequiredVersions(String string, List<IRequiredVersion> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getRequiredVersions(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IRequiredVersion>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(TestProgramTransformHelper.getRequiredVersionsFrom(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            return list;
        }
    }

    public ITestProgram getTestProgramByGfsId(String string, ITestProgram iTestProgram) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTestProgramByGfsId(" + string + ", " + iTestProgram + ")"));
        }
        boolean bl = iTestProgram != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFileWithoutDatabase(string, VAUDESObjekt.class);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            Pair<VAUDESStringTabelle, FkcMetaData> pair;
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"requested object not found in regular index, looking for \"access without object \"");
            }
            if (null != (pair = FunctiontestIndicator.getInstance().getFkcMetaDataFor(string))) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"found requested object");
                }
                return TestProgramTransformHelper.createDummyFkcDto(pair.getSecond());
            }
            if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
                try {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)"query database resolver");
                    }
                    VAUDESObjekt vAUDESObjekt = DatabaseResolver.getInstance().getFromDB(string, true);
                    if (bl) {
                        if (null == vAUDESObjekt) {
                            if (this.fLogger.isDebugEnabled()) {
                                this.fLogger.debug((Object)("return " + iTestProgram));
                            }
                            return iTestProgram;
                        }
                        TestProgramTransformHelper.transformTestProgram(iTestProgram, vAUDESObjekt);
                        if (this.fLogger.isDebugEnabled()) {
                            this.fLogger.debug((Object)("return merged " + iTestProgram));
                        }
                        return iTestProgram;
                    }
                    if (null == vAUDESObjekt) {
                        throw DbgHookTransformHelper.createOdisBaseException(string);
                    }
                    ITestProgram iTestProgram2 = TestProgramTransformHelper.createTestProgramObjectFrom(vAUDESObjekt);
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return new " + iTestProgram2));
                    }
                    return iTestProgram2;
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
                }
                catch (Exception exception) {
                    this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
                }
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTestProgram));
                }
                return iTestProgram;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        try {
            ITestProgram iTestProgram3 = TestProgramTransformHelper.createTestProgramObjectFrom(vAUDESObjekt);
            if (iTestProgram3 != null) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iTestProgram3));
                }
                return iTestProgram3;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTestProgram));
                }
                return iTestProgram;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (bl) {
                return iTestProgram;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
    }

    public ITestProgram getTestProgramByKey(String string, ITestProgram iTestProgram) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTestProgramByKey(" + string + ", " + iTestProgram + ")"));
        }
        boolean bl = iTestProgram != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFileWithoutDatabase(string, VAUDESObjekt.class);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            Pair<VAUDESStringTabelle, FkcMetaData> pair = FunctiontestIndicator.getInstance().getFkcMetaDataFor(string);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"requested object not found in regular index, looking for \"access without object\"");
            }
            if (null != pair) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"found requested object");
                }
                return TestProgramTransformHelper.createDummyFkcDto(pair.getSecond());
            }
            if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
                try {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)"query database resolver");
                    }
                    VAUDESObjekt vAUDESObjekt = DatabaseResolver.getInstance().getFromDB(string, true);
                    if (bl) {
                        if (null == vAUDESObjekt) {
                            if (this.fLogger.isDebugEnabled()) {
                                this.fLogger.debug((Object)("return " + iTestProgram));
                            }
                            return iTestProgram;
                        }
                        TestProgramTransformHelper.transformTestProgram(iTestProgram, vAUDESObjekt);
                        if (this.fLogger.isDebugEnabled()) {
                            this.fLogger.debug((Object)("return merged " + iTestProgram));
                        }
                        return iTestProgram;
                    }
                    if (null == vAUDESObjekt) {
                        throw DbgHookTransformHelper.createOdisBaseException(string);
                    }
                    ITestProgram iTestProgram2 = TestProgramTransformHelper.createTestProgramObjectFrom(vAUDESObjekt);
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return new " + iTestProgram2));
                    }
                    return iTestProgram2;
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
                }
                catch (Exception exception) {
                    this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
                }
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTestProgram));
                }
                return iTestProgram;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            ITestProgram iTestProgram3 = TestProgramTransformHelper.createTestProgramObjectFrom(vAUDESObjekt);
            if (iTestProgram3 != null) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iTestProgram3));
                }
                return iTestProgram3;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTestProgram));
                }
                return iTestProgram;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (bl) {
                return iTestProgram;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
    }

    public ITestProgram getTestProgramByClassname(String string, ITestProgram iTestProgram) throws OdisBaseException {
        String string2;
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTestProgramByClassname(" + string + ", " + iTestProgram + ")"));
        }
        boolean bl = iTestProgram != null;
        VAUDESObjekt vAUDESObjekt = null;
        try {
            vAUDESObjekt = TestProgramTransformHelper.getTestProgramByClassnameFromIndex(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with classname " + string + " from index"), (Throwable)exception);
        }
        if (!(vAUDESObjekt instanceof VAUDESObjekt)) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"requested object not found in regular index, looking for \"access without object\"");
            }
            string2 = this.makeSystemname(string);
            Pair<VAUDESStringTabelle, FkcMetaData> pair = FunctiontestIndicator.getInstance().getFkcMetaDataFor(string2);
            if (null != pair) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"found requested object");
                }
                return TestProgramTransformHelper.createDummyFkcDto(pair.getSecond());
            }
            if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
                try {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)"query database resolver");
                    }
                    vAUDESObjekt = DatabaseResolver.getInstance().getFromDB(string2, true);
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
                }
                catch (Exception exception) {
                    this.fLogger.error((Object)("Error transforming object " + string2), (Throwable)exception);
                }
            }
        }
        if (vAUDESObjekt instanceof VAUDESObjekt) {
            try {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"found requested object in index");
                }
                if ((string2 = TestProgramTransformHelper.createTestProgramObjectFrom(vAUDESObjekt)) != null) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return new " + string2));
                    }
                    return string2;
                }
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iTestProgram));
                    }
                    return iTestProgram;
                }
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error transforming object for classname " + string), (Throwable)exception);
                if (bl) {
                    return iTestProgram;
                }
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
        }
        if (bl) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return " + iTestProgram));
            }
            return iTestProgram;
        }
        throw DbgHookTransformHelper.createOdisBaseException(string);
    }

    private String makeSystemname(String string) {
        return StringUtils.substringBeforeLast((String)string, (String)"_") + "@" + StringUtils.substringAfterLast((String)string, (String)"_");
    }
}

