/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.domainmodel.diag.bean.IEquipmentNode;
import de.volkswagen.odis.vaudas.domainmodel.diag.factoryfacade.equipmentnode.EquipmentNodeFactoryFacade;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDiagnosticObject;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDocumentLink;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factoryfacade.diagnosticobject.DiagnosticObjectFactoryFacade;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factoryfacade.documentlink.DocumentLinkFactoryFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OverlayingFactoryObjectResolver {
    private static final Log LOGGER = LogFactory.getLog(OverlayingFactoryObjectResolver.class);
    private DiagnosticObjectFactoryFacade fDiagObjFacade = new DiagnosticObjectFactoryFacade();
    private EquipmentNodeFactoryFacade fEquipObjFacade = new EquipmentNodeFactoryFacade();
    private DocumentLinkFactoryFacade fDocObjFacade = new DocumentLinkFactoryFacade();

    private OverlayingFactoryObjectResolver() {
    }

    public static OverlayingFactoryObjectResolver getInstance() {
        return Holder.INSTANCE;
    }

    public IEquipmentNode getEquipmentNode(String string) {
        IEquipmentNode iEquipmentNode = null;
        try {
            IEquipmentNode iEquipmentNode2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Attempt to resolve asn-object from overlaying service: " + string));
            }
            if (null != (iEquipmentNode2 = this.fEquipObjFacade.getEquipmentNode(string))) {
                iEquipmentNode = iEquipmentNode2;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Successfully received object from overlaying service");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Failed to receive object from overlaying service");
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Resolving object from overlaying service not possible.", (Throwable)exception);
        }
        return iEquipmentNode;
    }

    public IDiagnosticObject getDiagnosticObject(String string) {
        IDiagnosticObject iDiagnosticObject = null;
        try {
            IDiagnosticObject iDiagnosticObject2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Attempt to resolve dg-object from overlaying service: " + string));
            }
            if (null != (iDiagnosticObject2 = this.fDiagObjFacade.getDiagnosticObject(string))) {
                iDiagnosticObject = iDiagnosticObject2;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Successfully received object from overlaying service");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Failed to receive object from overlaying service");
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Resolving object from overlaying service not possible.", (Throwable)exception);
        }
        return iDiagnosticObject;
    }

    public IDocumentLink getDoclink(String string) {
        IDocumentLink iDocumentLink;
        block12: {
            iDocumentLink = null;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Attempt to resolve document-object from overlaying service: " + string));
                }
                iDocumentLink = this.fDocObjFacade.getDocLinkByVaudesObjectId(string);
            }
            catch (Exception exception) {
                if (!LOGGER.isDebugEnabled()) break block12;
                LOGGER.debug((Object)exception);
            }
        }
        if (null != iDocumentLink) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Successfully received object from overlaying service via getDocLinkByVaudesObjectId()");
            }
        } else {
            block13: {
                try {
                    iDocumentLink = this.fDocObjFacade.getDocLink(string);
                }
                catch (Exception exception) {
                    if (!LOGGER.isDebugEnabled()) break block13;
                    LOGGER.debug((Object)exception);
                }
            }
            if (iDocumentLink != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Successfully received object from overlaying service via getDocLink()");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Failed to receive object from overlaying service");
            }
        }
        return iDocumentLink;
    }

    protected void setDiagObjFacade(DiagnosticObjectFactoryFacade diagnosticObjectFactoryFacade) {
        this.fDiagObjFacade = diagnosticObjectFactoryFacade;
    }

    protected void setEquipObjFacade(EquipmentNodeFactoryFacade equipmentNodeFactoryFacade) {
        this.fEquipObjFacade = equipmentNodeFactoryFacade;
    }

    protected void setDocObjFacade(DocumentLinkFactoryFacade documentLinkFactoryFacade) {
        this.fDocObjFacade = documentLinkFactoryFacade;
    }

    protected void init() {
        this.fDiagObjFacade = new DiagnosticObjectFactoryFacade();
        this.fEquipObjFacade = new EquipmentNodeFactoryFacade();
        this.fDocObjFacade = new DocumentLinkFactoryFacade();
    }

    private static class Holder {
        private static final OverlayingFactoryObjectResolver INSTANCE = new OverlayingFactoryObjectResolver();

        private Holder() {
        }
    }
}

