/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IMeasurementValueEntryKWP;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IMeasurementValueEntryUDS;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IMeasurementValueTable;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factory.IMeasurementValueTableFactory;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.MeasurementValueTableTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MeasurementValueTableFactoryImpl
implements IMeasurementValueTableFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public List<IMeasurementValueEntryKWP> getKwpEntries(String string, List<IMeasurementValueEntryKWP> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getKwpEntries(" + string + ", " + list + ")"));
        }
        Object object = null;
        if (null == list) {
            list = new ArrayList<IMeasurementValueEntryKWP>();
        }
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(MeasurementValueTableTransformHelper.getKwpEntrysFrom(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            return list;
        }
    }

    public IMeasurementValueEntryKWP getKwpEntry(String string, int n, IMeasurementValueEntryKWP iMeasurementValueEntryKWP) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getKwpEntry(" + string + ", " + iMeasurementValueEntryKWP + ")"));
        }
        boolean bl = iMeasurementValueEntryKWP != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                return iMeasurementValueEntryKWP;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            IMeasurementValueEntryKWP iMeasurementValueEntryKWP2 = MeasurementValueTableTransformHelper.createMeasurementValueEntryKwpFrom(vAUDESObjekt, n);
            if (null != iMeasurementValueEntryKWP2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iMeasurementValueEntryKWP2));
                }
                return iMeasurementValueEntryKWP2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iMeasurementValueEntryKWP));
                }
                return iMeasurementValueEntryKWP;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (null == iMeasurementValueEntryKWP) {
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            return iMeasurementValueEntryKWP;
        }
    }

    public IMeasurementValueTable getMeasurementValueTable(String string, IMeasurementValueTable iMeasurementValueTable) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getMeasurementValueTable(" + string + ", " + iMeasurementValueTable + ")"));
        }
        boolean bl = iMeasurementValueTable != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                return iMeasurementValueTable;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            IMeasurementValueTable iMeasurementValueTable2 = MeasurementValueTableTransformHelper.createMeasurementValueTableObjectFrom(vAUDESObjekt);
            if (null != iMeasurementValueTable2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iMeasurementValueTable2));
                }
                return iMeasurementValueTable2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iMeasurementValueTable));
                }
                return iMeasurementValueTable;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (null == iMeasurementValueTable) {
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            return iMeasurementValueTable;
        }
    }

    public List<String> getSuspicions(String string, int n, List<String> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getSuspicions(" + n + ", " + list + ")"));
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(MeasurementValueTableTransformHelper.getSuspicionsFromMeasurmentTableEntry(vAUDESObjekt, n));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            return list;
        }
    }

    public List<IMeasurementValueEntryUDS> getUdsEntries(String string, List<IMeasurementValueEntryUDS> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getUdsEntries(" + string + ", " + list + ")"));
        }
        Object object = null;
        if (null == list) {
            list = new ArrayList<IMeasurementValueEntryUDS>();
        }
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.info((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(MeasurementValueTableTransformHelper.getUdsEntrysFrom(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            return list;
        }
    }

    public IMeasurementValueEntryUDS getUdsEntry(String string, int n, IMeasurementValueEntryUDS iMeasurementValueEntryUDS) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getUdsEntry(" + string + ", " + n + ", " + iMeasurementValueEntryUDS + ")"));
        }
        boolean bl = iMeasurementValueEntryUDS != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                return iMeasurementValueEntryUDS;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            IMeasurementValueEntryUDS iMeasurementValueEntryUDS2 = MeasurementValueTableTransformHelper.createMeasurementValueEntryUdsFrom(vAUDESObjekt, n);
            if (null != iMeasurementValueEntryUDS2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iMeasurementValueEntryUDS2));
                }
                return iMeasurementValueEntryUDS2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iMeasurementValueEntryUDS));
                }
                return iMeasurementValueEntryUDS;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (bl) {
                return iMeasurementValueEntryUDS;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
    }
}

