/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.cache;

import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITranslatedText;
import de.vw.vaudes.diaghook.dto.HookTextIdWrapper;
import de.vw.vaudes.diaghook.transform.TranslatedTextTransformHelper;
import de.vw.vaudes.diaghook.util.LimitedSizeHashMap;
import java.lang.ref.SoftReference;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TextCache {
    private final Log fLogger = LogFactory.getLog(this.getClass());
    private final LimitedSizeHashMap<ITextId, SoftReference<ITranslatedText>> fCache = new LimitedSizeHashMap(150);

    private TextCache() {
    }

    public static TextCache getInstance() {
        return Holder.INSTANCE;
    }

    public ITranslatedText get(ITextId iTextId, Locale locale) {
        ITranslatedText iTranslatedText = null;
        SoftReference softReference = (SoftReference)this.fCache.get(this.getKey(iTextId));
        if (null == softReference) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Cache miss: " + iTextId + " with Locale " + locale));
            }
        } else {
            ITranslatedText iTranslatedText2 = (ITranslatedText)softReference.get();
            if (null == iTranslatedText2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("Reference in cache cleared: " + iTextId + " with Locale " + locale));
                }
            } else if (TranslatedTextTransformHelper.isLocaleEqual(iTranslatedText2.getLanguage(), locale)) {
                iTranslatedText = iTranslatedText2;
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("Cache hit: " + iTextId + " with Locale " + locale));
                }
            } else if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Text with " + locale + " requested, but " + iTranslatedText2.getLanguage() + " cached for: " + iTextId));
            }
        }
        return iTranslatedText;
    }

    private ITextId getKey(ITextId iTextId) {
        ITextId iTextId2 = iTextId;
        if (!(iTextId2 instanceof HookTextIdWrapper)) {
            iTextId2 = HookTextIdWrapper.create(iTextId2.getId(), iTextId2.getSource());
        }
        return iTextId2;
    }

    public void add(ITextId iTextId, ITranslatedText iTranslatedText) {
        ITextId iTextId2 = this.getKey(iTextId);
        if (this.fLogger.isDebugEnabled()) {
            SoftReference softReference = (SoftReference)this.fCache.get(iTextId2);
            if (null == softReference) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("Reference not cached yet: " + iTextId2 + " with Locale " + iTranslatedText.getLanguage()));
                }
            } else {
                ITranslatedText iTranslatedText2 = (ITranslatedText)softReference.get();
                if (null == iTranslatedText2) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("Reference cleared in cache: " + iTextId2 + " with Locale " + iTranslatedText.getLanguage()));
                    }
                } else {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("Reference already cached and gets overwritten: " + iTextId2 + " with Locale " + iTranslatedText.getLanguage()));
                    }
                    if (!TranslatedTextTransformHelper.isLocaleEqual(iTranslatedText2.getLanguage(), iTranslatedText.getLanguage()) && this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("Reference in Cache (" + iTranslatedText2.getLanguage() + ") gets overwriten by other language (" + iTranslatedText.getLanguage() + ")"));
                    }
                }
            }
        }
        this.fCache.put(iTextId2, new SoftReference<ITranslatedText>(iTranslatedText));
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("Added to cache: " + iTextId2 + " with Locale " + iTranslatedText.getLanguage()));
        }
    }

    public void reset() {
        this.fCache.clear();
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"Translated text cache cleared");
        }
    }

    protected LimitedSizeHashMap<ITextId, SoftReference<ITranslatedText>> getCache() {
        return this.fCache;
    }

    private static class Holder {
        private static final TextCache INSTANCE = new TextCache();

        private Holder() {
        }
    }
}

