@echo off
color 08

set SCRIPTVERSION=103

REM V1.0.3 -- 31.01.2023 -- # Das Praefix "ODIS" der Logdatei und des Logordners ersetzt durch "Diag" aus der Version V1.0.0
REM V1.0.0 -- 20.04.2021 -- # Initiale Version - keine Inhalte - keine Aktivitaeten


REM ####################################################
REM ### PATH erweitern fuer wmic #######################
REM ####################################################
SET "path=%path%;C:\Windows\;C:\Windows\System32\;C:\Windows\System32\wbem"

REM ####################################################
REM ### Returnvariablen definieren #####################
REM ####################################################
set SUCCESS=0
set REBOOT=0
set FAILURE=0

REM ####################################################
REM ### Logfile setzen #################################
REM ####################################################
if not exist "%programdata%\Diag_SetupLogs" md "%programdata%\Diag_SetupLogs"
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\diag_PLU_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""

REM ####################################################
REM ### Uebergabeparameter & Sonstiges #################
REM ####################################################
call :LOG "%time%" "Uebergabeparameter 1   (Product): %~1"
call :LOG "%time%" "Uebergabeparameter 2 (ODIS Path): %~2"
call :LOG "%time%" "Uebergabeparameter 3            : %~3"
call :LOG "%time%" ""
call :LOG "%time%" ""
for /f "tokens=*" %%i in ('ver') do set WindowsBuildNumber=%%i
call :LOG "%time%" "    Windows Version: %WindowsBuildNumber%"
call :LOG "%time%" "Aktueller Dateipfad: %~dp0"
call :LOG "%time%" "     Aktuelle Datei: %0"
call :LOG "%time%" "               Temp: %temp%"





REM ####################################################
REM ### NOTHING2DO #####################################
REM ####################################################
:NOTHING2DO
call :LOG ###
call :LOG "%time%" "Nothing to do here..."
call :LOG "%time%" "terminate the script"

set SUCCESS=1
GOTO END_SCRIPT






REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### ODIS Patch Last Update  ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Starte Log %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
if %1.==###. (
	echo.>> %logfile%
	echo "%time%" ################################################## >> %logfile%
) else (
	echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
)
goto :EOF



REM ####################################################
REM #### ENDMODULES ####################################
REM ####################################################

REM #### END_SCRIPT ############
:END_SCRIPT
call :LOG ###
call :LOG "%time%" "Terminating the script"
call :LOG "%time%" " 	SUCCESS: %SUCCESS%"
call :LOG "%time%" " 	REBOOT: %REBOOT%"
call :LOG "%time%" " 	FAILURE: %FAILURE%"
if %FAILURE%% EQU 1 GOTO NOK
if %REBOOT%% EQU 1 GOTO REBOOT
if %SUCCESS%% EQU 1 GOTO OK
GOTO :EXCEPTION

REM #### OK ############
:OK
call :LOG ###
call :LOG "%time%" "! ! ! Script finished successfully ! ! !"
EXIT /B 0

REM #### NOK ############
:NOK
call :LOG ###
call :LOG "%time%" "! ! ! Script failed ! ! !"
echo MSGBOX "!!! Error! Contact your administrator !!!" > %temp%\TEMPmessage.vbs
call %temp%\TEMPmessage.vbs >>%logfile% 2>&1
del %temp%\TEMPmessage.vbs /f /q >>%logfile% 2>&1
EXIT /B 1

REM #### REBOOT #########
:REBOOT
call :LOG ###
call :LOG "%time%" "Script finished successfully, but needs reboot. --- Script will show failure"
echo MSGBOX "!!! Please REBOOT your computer and run ODIS UPDATE again !!!" > %temp%\TEMPmessage.vbs
call %temp%\TEMPmessage.vbs >>%logfile% 2>&1
del %temp%\TEMPmessage.vbs /f /q >>%logfile% 2>&1
EXIT /B 2

REM #### EXCEPTION ############
:EXCEPTION
call :LOG ###
call :LOG "%time%" "!!! UNKNOWN ERROR ! Contact your Administrator !!!"
echo MSGBOX "!!! UNKNOWN ERROR - Contact your administrator !!!" > %temp%\TEMPmessage.vbs
call %temp%\TEMPmessage.vbs >>%logfile% 2>&1
del %temp%\TEMPmessage.vbs /f /q >>%logfile% 2>&1
EXIT /B 3