@echo off

REM ####################################################
REM ### Uninstall all VWMCDs ###########################
REM ####################################################
REM 
REM Changelog
REM v 1.0.9 - 10.10.2022
REM			- Ordner ODIS_SetupLogs ersetzt durch Diag_SetupLogs
REM v 1.0.8 - 26.11.2021
REM			- Anpassung auf Unterordner fuer VWMCD 18
REM v 1.0.7 - 30.07.2020
REM			- getMyDateMyTime - neu erstellt, um laenderspezifische Datumsformate zu verarbeiten
REM v 1.0.6 - 22.07.2020
REM			for Schleife mit delayedExpansions erweitert, samt Variablen, fuer korrekte Zeitausgabe in der Schleife
REM			Timeout mit Hilfe von Ping in Schleife eingebaut, das es sonst zu Zeitlicher Uerberlappung der Installer gekommen ist
REM v 1.0.5 - 07.07.2020
REM			Alle Uninstaller sollen Log schreiben, welches an das haupt-Log angefuegt wird
REM v 1.0.4 - 07.07.2020
REM			slebst loeschen ueberarbeitet
REM v 1.0.3 - 08.08.2019
REM			Das Script löscht sich selbst sowie den übergeordneten Ordner
REM v 1.0.2 - 29.01.2019
REM			Pfad fuer Logging angepasst
REM v 1.0.1 - 29.01.2019
REM			/LOG Parameter hinzugefuegt
REM v 1.0.0 - 14.02.2018
REM 		Script initial von V.Poaka erstellt
REM 		Script auf eine Datei reduziert und Auswertung der Rückgabewerte hinzugefuegt
REM 
REM ####################################################



cd /d "%~dp0"
set SCRIPTVERSION=109
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\Uninstall_all_VWMCD_%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""

set error=0
set errorSum=0

call :LOG "%time%" "Uninstall VW-MCD MCD-Kernel..."
cd Uninstaller\"VW-MCD MCD-Kernel"
setlocal enabledelayedexpansion
for /f "tokens=*" %%A in ('dir *.exe /b') do (
	call :LOG "!time!" "#########################################"
	call :LOG "!time!" "### Uninstall %%~dpnxA ###"
	call "%%~dpnxA" "/VERYSILENT" "/SUPPRESSMSGBOXES" "/NORESTART" "/CLOSEAPPLICATIONS" "/overwrite" "/LOG=!programdata!\Diag_SetupLogs\temp_Uninstall_VWMCD.log"
	set error=!ERRORLEVEL!
	call :LOG "!time!" "    uninstall %%~dpnxA returned: !error!"
	set /a errorSum = !errorSum! + !error!
	call :LOG "!time!" "	--- Full Log ------------------------"
	type "!programdata!\Diag_SetupLogs\temp_Uninstall_VWMCD.log">>!logfile!
	call :LOG "!time!" "	--- Full Log end --------------------"
	call :LOG "!time!" "### waiting some seconds . . .           "
	ping 127.0.0.1 -n 4 > nul
	call :LOG "!time!" "#########################################"
)
endlocal

call :LOG "%time%" "Uninstall VW-MCD ODX-Converter..."
cd..\"VW-MCD ODX-Converter"
setlocal enabledelayedexpansion
for /f "tokens=*" %%A in ('dir *.exe /b') do (
	call :LOG "!time!" "#########################################"
	call :LOG "!time!" "### Uninstall %%~dpnxA ###"
	call "%%~dpnxA" "/VERYSILENT" "/SUPPRESSMSGBOXES" "/NORESTART" "/CLOSEAPPLICATIONS" "/overwrite" "/LOG=!programdata!\Diag_SetupLogs\temp_Uninstall_VWMCD.log"
	set error=!ERRORLEVEL!
	call :LOG "!time!" "    uninstall %%~dpnxA returned: !error!"
	set /a errorSum = !errorSum! + !error!
	call :LOG "!time!" "	--- Full Log ------------------------"
	type "!programdata!\Diag_SetupLogs\temp_Uninstall_VWMCD.log">>!logfile!
	call :LOG "!time!" "	--- Full Log end --------------------"
	call :LOG "!time!" "### waiting some seconds . . .           "
	ping 127.0.0.1 -n 4 > nul
	call :LOG "!time!" "#########################################"
)
endlocal

if not exist "%~dp0\Uninstaller\VW-MCD PDX-Builder" goto :skipPdxBuilder
call :LOG "%time%" "Uninstall VW-MCD PDX-Builder..."
cd..\"VW-MCD PDX-Builder"
setlocal enabledelayedexpansion
	for /f "tokens=*" %%A in ('dir *.exe /b') do (
	call :LOG "!time!" "#########################################"
	call :LOG "!time!" "### Uninstall %%~dpnxA ###"
	call "%%~dpnxA" "/VERYSILENT" "/SUPPRESSMSGBOXES" "/NORESTART" "/CLOSEAPPLICATIONS" "/overwrite" "/LOG=!programdata!\Diag_SetupLogs\temp_Uninstall_VWMCD.log"
	set error=!ERRORLEVEL!
	call :LOG "!time!" "    uninstall %%~dpnxA returned: !error!"
	set /a errorSum = !errorSum! + !error!
	call :LOG "!time!" "	--- Full Log ------------------------"
	type "!programdata!\Diag_SetupLogs\temp_Uninstall_VWMCD.log">>!logfile!
	call :LOG "!time!" "	--- Full Log end --------------------"
	call :LOG "!time!" "### waiting some seconds . . .           "
	ping 127.0.0.1 -n 4 > nul
	call :LOG "!time!" "#########################################"
)
endlocal
:skipPdxBuilder


call :LOG "%time%" ""
call :LOG "%time%" "Sum of all Uninstallers: %errorSum%"
call :LOG "%time%" ""
call :LOG "%time%" "Now detete %~dp0"
call :LOG "%time%" "And exit with: %errorSum%"

cd "%~dp0"\..
goto 2>nul & rd /s /q "%~dp0" & cmd /c exit %errorSum%




REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### ODIS Uninstall VW-MCD   ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Logfile %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
goto :EOF