/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.wireadmin;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.wireadmin.WireAdminImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.wireadmin.WireAdmin;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;

public class Activator
implements BundleActivator {
    private static final String WIREADMIN_PID = "org.apache.felix.wireadmin";
    private ServiceRegistration m_reg = null;
    private WireAdminImpl m_wai = null;

    public void start(BundleContext bundleContext) throws BundleException {
        String value;
        this.m_wai = new WireAdminImpl(bundleContext);
        Properties properties = new Properties();
        ((Dictionary)properties).put("wireadmin.pid", WIREADMIN_PID);
        this.m_reg = bundleContext.registerService(WireAdmin.class.getName(), (Object)this.m_wai, (Dictionary)properties);
        this.m_wai.setServiceReference(this.m_reg.getReference());
        if (bundleContext.getProperty("fr.imag.adele.wireadmin.traceEvt") != null && (value = bundleContext.getProperty("fr.imag.adele.wireadmin.traceEvt")).equals("true")) {
            Properties props = new Properties();
            ((Dictionary)props).put("wireadmin.events", new Integer(255));
            ((Dictionary)properties).put("wireadmin.pid", WIREADMIN_PID);
            bundleContext.registerService(WireAdminListener.class.getName(), (Object)new eventTracer(), (Dictionary)props);
        }
    }

    public void stop(BundleContext bundleContext) throws BundleException {
        this.m_wai.releaseAll();
        this.m_wai = null;
    }

    class eventTracer
    implements WireAdminListener {
        eventTracer() {
        }

        public void wireAdminEvent(WireAdminEvent evt) {
            int type = evt.getType();
            if ((type & 4) != 0) {
                WireAdminImpl.traceln("Received event WIRE_CREATED");
            }
            if ((type & 0x20) != 0) {
                WireAdminImpl.traceln("Received event WIRE_CONNECTED");
            }
            if ((type & 8) != 0) {
                WireAdminImpl.traceln("Received event WIRE_UPDATED");
            }
            if ((type & 0x80) != 0) {
                WireAdminImpl.traceln("Received event WIRE_TRACE");
            }
            if ((type & 0x40) != 0) {
                WireAdminImpl.traceln("Received event WIRE_DISCONNECTED");
            }
            if ((type & 0x10) != 0) {
                WireAdminImpl.traceln("Received event WIRE_DELETED");
            }
            if ((type & 1) != 0) {
                WireAdminImpl.traceln("Received event PRODUCER_EXCEPTION");
                evt.getThrowable().printStackTrace();
            }
            if ((type & 2) != 0) {
                WireAdminImpl.traceln("Received event CONSUMER_EXCEPTION");
                evt.getThrowable().printStackTrace();
            }
        }
    }
}

