/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.ManifestDigester;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public class SignatureFile {
    private final Manifest fSf;
    private final String fBaseName;

    public SignatureFile(MessageDigest[] messageDigestArray, Manifest manifest, ManifestDigester manifestDigester, String string, boolean bl) {
        this.fBaseName = string;
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("java.vendor");
        this.fSf = new Manifest();
        Attributes attributes = this.fSf.getMainAttributes();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        attributes.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        attributes.putValue("Created-By", String.valueOf(string2) + " (" + string3 + ")");
        if (bl) {
            int n = 0;
            while (n < messageDigestArray.length) {
                attributes.putValue(String.valueOf(messageDigestArray[n].getAlgorithm()) + "-Digest-Manifest", bASE64Encoder.encode(manifestDigester.manifestDigest(messageDigestArray[n])));
                ++n;
            }
        }
        Map<String, Attributes> map = this.fSf.getEntries();
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            String string4 = entry.getKey();
            ManifestDigester.Entry entry2 = manifestDigester.get(string4, false);
            if (entry2 == null) continue;
            Attributes attributes2 = new Attributes();
            int n = 0;
            while (n < messageDigestArray.length) {
                attributes2.putValue(String.valueOf(messageDigestArray[n].getAlgorithm()) + "-Digest", bASE64Encoder.encode(entry2.digest(messageDigestArray[n])));
                ++n;
            }
            map.put(string4, attributes2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.fSf.write(outputStream);
    }

    public String getMetaName() {
        return "META-INF/" + this.fBaseName + ".SF";
    }

    public String getBaseName() {
        return this.fBaseName;
    }

    public Block generateBlock(PrivateKey privateKey, X509Certificate[] x509CertificateArray, boolean bl) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
        return new Block(this, privateKey, x509CertificateArray, bl);
    }

    public static class Block {
        private final PKCS7 fBlock;
        private final String fBlockFileName;

        public String getMetaName() {
            return this.fBlockFileName;
        }

        public void write(OutputStream outputStream) throws IOException {
            this.fBlock.encodeSignedData(outputStream);
        }

        Block(SignatureFile signatureFile, PrivateKey privateKey, X509Certificate[] x509CertificateArray, boolean bl) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
            String string;
            Object object;
            Principal principal = x509CertificateArray[0].getIssuerDN();
            if (!(principal instanceof X500Name)) {
                object = new X509CertInfo(x509CertificateArray[0].getTBSCertificate());
                principal = (Principal)object.get("issuer.dname");
            }
            object = x509CertificateArray[0].getSerialNumber();
            String string2 = privateKey.getAlgorithm();
            if (string2.equalsIgnoreCase("DSA")) {
                string = "SHA1";
            } else if (string2.equalsIgnoreCase("RSA")) {
                string = "MD5";
            } else {
                throw new RuntimeException("private key is not a DSA or RSA key");
            }
            String string3 = String.valueOf(string) + "with" + string2;
            this.fBlockFileName = "META-INF/" + signatureFile.getBaseName() + "." + string2;
            AlgorithmId algorithmId = AlgorithmId.get(string);
            AlgorithmId.get(string3);
            AlgorithmId algorithmId2 = AlgorithmId.get(string2);
            Signature signature = Signature.getInstance(string3);
            signature.initSign(privateKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            signatureFile.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ContentInfo contentInfo = bl ? new ContentInfo(ContentInfo.DATA_OID, null) : new ContentInfo(byArray);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            SignerInfo signerInfo = new SignerInfo((X500Name)principal, (BigInteger)object, algorithmId, algorithmId2, byArray2);
            AlgorithmId[] algorithmIdArray = new AlgorithmId[]{algorithmId};
            SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
            this.fBlock = new PKCS7(algorithmIdArray, contentInfo, x509CertificateArray, signerInfoArray);
        }
    }
}

