-- Create-Script fr didb_Basis
-- Diagnoseinformations-Datenbank / Datenbankgruppe Basis / Strukturdatenbank
--
-- Rolf Hauck / 08.04.2010 / herausgelst aus dem ursprnglichen einheitlichen createTables.sql.
-- Rolf Hauck / 09.06.2010 / neue Tabellen EcuBaseInformation und EcuBaseLink (Abbildung System_5Baud_LL_Table der KD-Referenztabellen)
-- Rolf Hauck / 05.07.2010 / Tabelle FormulaProperty entfernt.

-- zunchst alle Tabellen lschen

DROP TABLE DtcCodeReference               IF EXISTS CASCADE;
DROP TABLE EcuBaseInformation             IF EXISTS CASCADE;
DROP TABLE EcuBaseLink                    IF EXISTS CASCADE;

-- alle Tabellen erzeugen, ohne Constraints oder Keys

CREATE TABLE DtcCodeReference
(
	TextId     varchar(64) NOT NULL,
	DtcVag     varchar(16)     NULL,
	DtcSae     varchar(16)     NULL,
	PCode      varchar(16)     NULL
);

CREATE TABLE EcuBaseInformation
(
	Shortname         varchar(16) NOT NULL,
	TextId            varchar(64) NOT NULL,
	FiveBaudAddress   varchar(8)  NOT NULL,
	Longname          varchar(16) NOT NULL,
	Symbol            varchar(16) NOT NULL,
	KWPAvailable      boolean      NOT NULL,
	KWPNoVariants     boolean      NOT NULL
);

CREATE TABLE EcuBaseLink
(
	Shortname         varchar(16) NOT NULL,
	Linkname          varchar(16) NOT NULL
);

-- jetzt die Primary Keys erzeugen
-- nicht alle Tabellen haben einen Primary Key

-- kein PK fr DtcCodeReference
ALTER TABLE EcuBaseInformation ADD CONSTRAINT PK_EcuBaseInformation  PRIMARY KEY (Shortname);
ALTER TABLE EcuBaseLink ADD CONSTRAINT PK_EcuBaseLink  PRIMARY KEY (Shortname, Linkname);

-- erst nach den Primary Keys die Foreign Keys erzeugen
ALTER TABLE EcuBaseLink ADD CONSTRAINT FK_EcuBaseLink_EcuBaseInformation
FOREIGN KEY(Shortname) REFERENCES EcuBaseInformation (Shortname);
