﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 
	<xsl:param name="Text_ProjContent">MCD-Projekt-Inhalt</xsl:param>
	<xsl:param name="Text_Versions">Versionen</xsl:param>
	<xsl:param name="Text_Language">Sprache</xsl:param>
	<xsl:param name="Text_Bezeichn">Bezeichnung</xsl:param>
	<xsl:param name="Text_Status">Status</xsl:param>
	<xsl:param name="Text_ErstKommentar">Erstellungskommentar</xsl:param>
	<xsl:param name="Text_NotAvailable">nicht vorhanden</xsl:param>
	<xsl:param name="Text_File">Datei</xsl:param>
	<xsl:param name="Text_Date">Datum</xsl:param>
	<xsl:param name="Text_Change">Änderung</xsl:param>
	<xsl:param name="Text_Category">Kategorie</xsl:param>
 
 
<xsl:template match="CATALOG">
  <html>
    <head>
	 <style type="text/css">
	  table {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  tr {border-width:0;padding:0;margin:0;text-align:left}
	  td {border-width:0;padding:0;margin:0;text-align:left}
	  span {margin-top:0pt;margin-bottom:0pt}
	  div {margin-top:0pt;margin-bottom:10pt;margin-left:16pt}
	  pre {margin-top:0pt;margin-botton:0pt;font-family:Arial;direction:ltr}
	  p {margin-top:0pt;margin-bottom:0pt}
	  .p_mini {margin-top:0pt;margin-bottom:0pt}
	  .p_small {margin-top:10pt;margin-bottom:10pt}
	  .p_big {margin-top:16pt;margin-bottom:16pt}
	  .courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:ltr}
	  .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_bu {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_big_bi {margin-top:0;margin-bottom:0;font-size:16pt;font-family:Arial;font-weight:bold;font-style:italic;direction:ltr}
	  .default_style_big_b {margin-top:0;margin-bottom:0;font-size:20pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_big {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_bigu {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
	  .header_style_small {margin-top:0;margin-bottom:0;font-size:11pt;font-family:Arial;direction:ltr}
	  .small_style {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;direction:ltr}
	  .very_small_style {margin-top:0;margin-bottom:0;font-size:6pt;font-family:Arial;direction:ltr}
	  .small_style_b {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .small_style_bu {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}

      .font_arial {font-family:Arial}
      .font_courier {font-family:"Courier New"}
      .font_sidis {font-family:SidisSymbole}
      .font_symbol {font-family:"Symbol"}
      .font_wingdings {font-family:"Wingdings"}
	  .size_small {font-size:10pt}
	  .size_big {font-size:12pt}
	  .color_black {color:#000000}
	  .color_red {color:#FF0000}
	  .color_green {color:#006400}
	  .color_blue {color:#0000FF}
	  .color_yellow {color:#FFF405}
	  .color_green2 {color:#92C027}
	  .color_blue2 {color:#6BBCE4}
	  .style_normal {font-style:normal}
	  .style_italic {font-style:italic}
	  .weight_normal {font-weight:normal}
	  .weight_bold {font-weight:bold}

	  .table_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  
	  @media screen 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  }
	  @media print 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  }
	</style>

	<script language="JavaScript"><xsl:comment>
		 
	   var versionXsl = 75;


<![CDATA[ 
	   function ReadVersion(version,attentionStr,versionStr,warningStr)
	   { 
		 var versionXml = parseInt(version,10);
		 if( versionXml > versionXsl)
		 {
			document.write('<p class="p_big"></p>');
			document.write('<table><tr><td style="text-align:center;border-width=4;border-color:black;border-style:solid">');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + attentionStr + '</p>');
			document.write('<p class="default_style_big_b">' + versionStr + ':</p>');
			document.write('<p class="default_style_big_b">XSL V.' + versionXsl + ' / XML V.' + versionXml + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + warningStr + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('</td></tr></table>');
			document.write('<p class="p_big">&#160;</p>');
		}
	   }
]]>

	</xsl:comment></script>

    <title><xsl:value-of select="SHORT-NAME" /></title></head>
    <body>

	 <table style="border-bottom-style=groove;border-bottom-color=black;border-bottom-width=2">
	  <tr>

	   <td valign='bottom' style='width:45mm;text-align:left'>
	    <p class="header_style_big"><xsl:value-of select="SHORT-NAME" />
	    </p>
	   </td>
 
	   <td valign='bottom' style='width:80mm;text-align:center'>
	    <p class="header_style_big">
		 <xsl:value-of select="$Text_ProjContent"/>
	    </p>
	   </td>
  
	   <td valign='bottom' style='width:45mm;text-align:right'>
	    <p class="header_style_small"></p>
	   </td>
  
	 </tr>
	</table>

	<p class="p_small"></p>

	<script language='JavaScript'>ReadVersion('<xsl:value-of select="xsl_version" />','<xsl:value-of select="attention_string" />','<xsl:value-of select="version_string" />','<xsl:value-of select="warning_string" />')</script>

	 <table>
	  <tr>

	   <xsl:for-each select="ADMIN-DATA/DOC-REVISIONS">
	    <td valign='top' style='width:105mm'>
	     <p class="default_style_bu"><xsl:value-of select="$Text_Versions"/><xsl:text>:</xsl:text></p>
	    </td>
	   </xsl:for-each>

	   <xsl:for-each select="ADMIN-DATA/LANGUAGE">
	    <td valign='top' style='width:65mm'>
	     <p class="default_style_bu"><xsl:value-of select="$Text_Language"/><xsl:text>:</xsl:text></p>
	    </td>
	   </xsl:for-each>
	  </tr>
	  <tr>
	   <xsl:for-each select="ADMIN-DATA/DOC-REVISIONS">
	    <td valign='top' style='width:105mm'>
	    <div>
	     <xsl:for-each select="DOC-REVISION">
	       <xsl:for-each select="TOOL">
	         <p class="default_style_b"><xsl:value-of select="." />
	         <div>
		   <p class="default_style">
		     <xsl:for-each select="../REVISION-LABEL">
			     <xsl:value-of select="$Text_Bezeichn"/>
                 <xsl:text>: </xsl:text><xsl:value-of select="." /><br /></xsl:for-each>
	      	     <xsl:for-each select="../STATE">
				 <xsl:value-of select="$Text_Status"/>
                 <xsl:text>: </xsl:text><xsl:value-of select="." /><br /></xsl:for-each>
	      	     <xsl:for-each select="../DATE"><xsl:call-template name="display_timestamp"><xsl:with-param name="date"><xsl:value-of select="." /></xsl:with-param></xsl:call-template><br /></xsl:for-each>
	      	   </p>
	     	 </div>
	     	 </p>
	       </xsl:for-each>
	     </xsl:for-each>
	     </div>
	    </td>
	   </xsl:for-each>
	   <xsl:for-each select="ADMIN-DATA/LANGUAGE">
	    <td valign='top' style='width:65mm'>
	     <div>
	     <p class="default_style"><xsl:value-of select="." /></p>
	     </div>
	    </td>
	   </xsl:for-each>
	  </tr>
 	  <tr>
	  <td colspan="2">
	  <p class="default_style_bu"><xsl:value-of select="$Text_ErstKommentar"/><xsl:text>:</xsl:text></p>
	  <p class="default_style">
	     <pre>
	  	<xsl:if test="COMMENT"><xsl:for-each select="COMMENT"><xsl:value-of select="." /></xsl:for-each></xsl:if>
	  	<xsl:if test="not(COMMENT)"><xsl:value-of select="$Text_NotAvailable"/></xsl:if>
	     </pre>
	  </p>
	  </td>
	  </tr>
	 </table>

	 <p class="p_small"></p>

	 <table>
	 <tr>
	 <td><p class="default_style_bu"><xsl:value-of select="$Text_File"/></p></td>
	 <td><p class="default_style_bu"><xsl:value-of select="$Text_Date"/></p></td>
	 <td><p class="default_style_bu"><xsl:value-of select="$Text_Change"/></p></td>
	 <td><p class="default_style_bu"><xsl:value-of select="$Text_Category"/></p></td>
	 </tr>
	 <xsl:for-each select="ABLOCKS/ABLOCK">
	 <xsl:sort select="CATEGORY" />  
	 <xsl:sort select="SHORT-NAME" />  
	 <tr>
	  <td valign='top' style='width:105mm'>
	  <xsl:for-each select="FILES/FILE"><p class="default_style"><xsl:value-of select="." /></p></xsl:for-each>
	  </td>
	  <td valign='top' style='width:30mm'>
	  <xsl:for-each select="FILES/FILE"><p class="default_style"><xsl:value-of select="@CREATION-DATE" /></p></xsl:for-each>
	  </td>
	  <td valign='top' style='width:30mm'>
	  <p class="default_style"><xsl:value-of select="@UPD" /></p>
          </td>
	  <td valign='top' style='width:30mm'>
	  <p class="default_style"><xsl:value-of select="CATEGORY" /></p>
	  </td>
	 </tr>
	 </xsl:for-each>

      </table>
    </body>
  </html>
</xsl:template>


<xsl:template name="display_timestamp">
  <xsl:param name="date" />
  <xsl:if test="$date!=''">
    <xsl:value-of select="substring($date,9,2)"/><xsl:text>.</xsl:text>
    <xsl:value-of select="substring($date,6,2)"/><xsl:text>.</xsl:text>
    <xsl:value-of select="substring($date,1,4)"/><xsl:text> </xsl:text>
    <xsl:value-of select="substring($date,12,8)"/>
  </xsl:if>  
</xsl:template>

</xsl:stylesheet>