<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  	<xsl:param name="Text_BzdVergl">Bauzustandsvergleich</xsl:param>
  	<xsl:param name="Text_Error">Fehler</xsl:param>
  	<xsl:param name="Text_Protokoll">Protokoll</xsl:param>
  	<xsl:param name="Text_NoOeProt">ist kein ODIS-Engineering Protokoll</xsl:param>
  	<xsl:param name="Text_Vehicle">Fahrzeug</xsl:param>
  	<xsl:param name="Text_Milage">Laufleistung</xsl:param>
  	<xsl:param name="Text_McdProj">MCD-Projekt</xsl:param>
  	<xsl:param name="Text_McdProjVers">MCD-Projekt Version</xsl:param>
  	<xsl:param name="Text_Date">Datum</xsl:param>
  	<xsl:param name="Text_FileName">Dateiname</xsl:param>
  	<xsl:param name="Text_AlleUntersch">Zusammenfassung aller Unterschiede</xsl:param>
  	<xsl:param name="Text_Ecu">ECU</xsl:param>
  	<xsl:param name="Text_Subsystem">Diagnoseprotokoll</xsl:param>

  	<xsl:param name="leftdocname" />
	<xsl:param name="rightdocname" />
	
	<xsl:variable name="left" select="document($leftdocname)"/>
	<xsl:variable name="right" select="document($rightdocname)"/>
	
	<xsl:variable name="TI_SYSTEMBEZEICHNUNG">IDE00013</xsl:variable>
	<xsl:variable name="TI_SUBSYSTEMBEZEICHNUNG">MAS01171</xsl:variable>
	
	<xsl:variable name="leftdocdisplayname"><xsl:call-template name="fileName"><xsl:with-param name="path" select="$leftdocname" /></xsl:call-template></xsl:variable>
	<xsl:variable name="rightdocdisplayname"><xsl:call-template name="fileName"><xsl:with-param name="path" select="$rightdocname" /></xsl:call-template></xsl:variable>
	
	<xsl:template match="protocol">
		<html>
			<head>
				<style type="text/css">
	  table {border-width:0pt;border-color:black;border-style:solid;border-collapse:collapse;padding:0;margin:0;width:170mm;table-layout:auto}
	  .border_style {border-width:1pt;border-color:black;border-style:solid;border-collapse:collapse;padding-left:5;padding-right:5;margin-top:10;margin-bottom:10;width:165mm}
	  tr {border-width:0pt;border-color:black;border-style:solid;padding:0;margin:0;text-align:left}
	  td {border-width:0pt;border-color:black;border-style:solid;padding:0;margin:0;text-align:left}
	  span {margin-top:0pt;margin-bottom:0pt}
	  div {margin-top:0pt;margin-bottom:10pt;margin-left:16pt}
	  p {margin-top:0pt;margin-bottom:0pt}
	  .p_mini {margin-top:0pt;margin-bottom:0pt}
	  .p_small {margin-top:10pt;margin-bottom:10pt}
	  .p_big {margin-top:16pt;margin-bottom:16pt}
	  .courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:ltr}
	  .default_error {color:red;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_ok {color:green;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .compstyleNOK {color:red;margin-top:0;margin-bottom:0;font-size:10pt;font-weight:bold;font-family:Arial;direction:ltr}
	  .compstyleOK {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_topmargin {margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_bu {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_bu_topmargin {margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_ecu {background-color:#E0E0E0;margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_big_bi {margin-top:0;margin-bottom:0;font-size:16pt;font-family:Arial;font-weight:bold;font-style:italic;direction:ltr}
	  .default_style_big_b {margin-top:0;margin-bottom:0;font-size:20pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_big {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_bigu {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
	  .header_style_small {margin-top:0;margin-bottom:0;font-size:11pt;font-family:Arial;direction:ltr}
	  .small_style {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;direction:ltr}
	  .very_small_style {margin-top:0;margin-bottom:0;font-size:6pt;font-family:Arial;direction:ltr}
	  .small_style_b {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .small_style_bu {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}

      .font_arial {font-family:Arial}
      .font_courier {font-family:"Courier New"}
      .font_sidis {font-family:SidisSymbole}
      .font_symbol {font-family:"Symbol"}
      .font_wingdings {font-family:"Wingdings"}
	  .size_small {font-size:10pt}
	  .size_big {font-size:12pt}
	  .color_black {color:#000000}
	  .color_red {color:#FF0000}
	  .color_green {color:#006400}
	  .color_blue {color:#0000FF}
	  .color_yellow {color:#FFF405}
	  .color_green2 {color:#92C027}
	  .color_blue2 {color:#6BBCE4}
	  .style_normal {font-style:normal}
	  .style_italic {font-style:italic}
	  .weight_normal {font-weight:normal}
	  .weight_bold {font-weight:bold}

	  .table_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  
	  @media screen 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
		p {margin-top:0pt;margin-bottom:0pt }
		.nichtdrucken {font-size:10pt;font-family:Arial;direction:ltr}
	  }
	  @media print 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
		p {margin-top:0pt;margin-bottom:0pt }
		.nichtdrucken {font-size:10pt;font-family:Arial;direction:ltr;display:none}
	  }
	</style>

	<title><xsl:value-of select="$Text_BzdVergl"/></title>
			</head>
			<body>
				<table style="border-bottom-style=groove;border-bottom-color=black;border-bottom-width=2">
					<tr>
						<td valign="bottom" style="text-align:left">
							<p class="header_style_big">
								<xsl:value-of select="information/software_name"/> <xsl:value-of select="$Text_BzdVergl"/>
							</p>
						</td>
					</tr>
				</table>
				<p class="p_small"/>
				
				<xsl:choose>
				
					<xsl:when test="not($left/protocol/information/software_name='ODIS Engineering') or not($right/protocol/information/software_name='ODIS Engineering')">
						<xsl:if test="not($left/protocol/information/software_name='ODIS Engineering')">
							<p class="compstyleNOK"><xsl:value-of select="$Text_Error"/><xsl:text>: </xsl:text><xsl:value-of select="$Text_Protokoll"/><xsl:text> "</xsl:text><xsl:value-of select="$leftdocdisplayname" /><xsl:text>" </xsl:text><xsl:value-of select="$Text_NoOeProt"/><xsl:text>!</xsl:text></p>
						</xsl:if>
						<xsl:if test="not($right/protocol/information/software_name='ODIS Engineering')">
							<p class="compstyleNOK"><xsl:value-of select="$Text_Error"/><xsl:text>: </xsl:text><xsl:value-of select="$Text_Protokoll"/><xsl:text> "</xsl:text><xsl:value-of select="$rightdocdisplayname" /><xsl:text>" </xsl:text><xsl:value-of select="$Text_NoOeProt"/><xsl:text>!</xsl:text></p>
						</xsl:if>
					</xsl:when>
				
					<xsl:otherwise>
                				<table>
                					<xsl:variable name="left_vin"><xsl:value-of select="$left//vehicle/vehicle_data[display_name='vin']/display_value"/></xsl:variable>
                					<xsl:variable name="right_vin"><xsl:value-of select="$right//vehicle/vehicle_data[display_name='vin']/display_value"/></xsl:variable>
                					<xsl:call-template name="header_comparison">
								<xsl:with-param name="label"><xsl:value-of select="$Text_Vehicle"/></xsl:with-param>
                						<xsl:with-param name="left_display_value"><xsl:value-of select="$left_vin" /></xsl:with-param>
                						<xsl:with-param name="right_display_value"><xsl:value-of select="$right_vin" /></xsl:with-param>
                					</xsl:call-template>
                
                					<xsl:variable name="left_internal_vehicle_nb"><xsl:value-of select="$left//vehicle/vehicle_data[display_name='internal_vehicle_nb']/display_value"/></xsl:variable>
                					<xsl:variable name="right_internal_vehicle_nb"><xsl:value-of select="$right//vehicle/vehicle_data[display_name='internal_vehicle_nb']/display_value"/></xsl:variable>
                					<xsl:call-template name="header_comparison">
                						<xsl:with-param name="label"></xsl:with-param>
                						<xsl:with-param name="left_display_value"><xsl:value-of select="$left_internal_vehicle_nb" /></xsl:with-param>
                						<xsl:with-param name="right_display_value"><xsl:value-of select="$right_internal_vehicle_nb" /></xsl:with-param>
                					</xsl:call-template>
                
                					<xsl:variable name="left_mileage">
                						<xsl:value-of select="$left//vehicle/vehicle_data[display_name='mileage']/display_value"/>
                						<xsl:text> </xsl:text>
                						<xsl:value-of select="$left//vehicle/vehicle_data[display_name='unit_of_mileage']/display_value"/>
                					</xsl:variable>
                					<xsl:variable name="right_mileage">
                						<xsl:value-of select="$right//vehicle/vehicle_data[display_name='mileage']/display_value"/>
                						<xsl:text> </xsl:text>
                						<xsl:value-of select="$right//vehicle/vehicle_data[display_name='unit_of_mileage']/display_value"/>
                					</xsl:variable>
                					<xsl:call-template name="header_comparison">
								<xsl:with-param name="label"><xsl:value-of select="$Text_Milage"/></xsl:with-param>
                						<xsl:with-param name="left_display_value"><xsl:value-of select="$left_mileage" /></xsl:with-param>
                						<xsl:with-param name="right_display_value"><xsl:value-of select="$right_mileage" /></xsl:with-param>
                					</xsl:call-template>
                							
                					<xsl:variable name="left_mcd_project"><xsl:value-of select="$left//vehicle/odx_info[display_name='project']/display_value"/></xsl:variable>
                					<xsl:variable name="right_mcd_project"><xsl:value-of select="$right//vehicle/odx_info[display_name='project']/display_value"/></xsl:variable>
                					<xsl:call-template name="header_comparison">
								<xsl:with-param name="label"><xsl:value-of select="$Text_McdProj"/></xsl:with-param>
                						<xsl:with-param name="left_display_value"><xsl:value-of select="$left_mcd_project" /></xsl:with-param>
                						<xsl:with-param name="right_display_value"><xsl:value-of select="$right_mcd_project" /></xsl:with-param>
                					</xsl:call-template>
                							
                					<xsl:variable name="left_mcd_project_version"><xsl:value-of select="$left//vehicle/odx_info[display_name='project_version']/display_value"/></xsl:variable>
                					<xsl:variable name="right_mcd_project_version"><xsl:value-of select="$right//vehicle/odx_info[display_name='project_version']/display_value"/></xsl:variable>
                					<xsl:call-template name="header_comparison">
								<xsl:with-param name="label"><xsl:value-of select="$Text_McdProjVers"/></xsl:with-param>
                						<xsl:with-param name="left_display_value"><xsl:value-of select="$left_mcd_project_version" /></xsl:with-param>
                						<xsl:with-param name="right_display_value"><xsl:value-of select="$right_mcd_project_version" /></xsl:with-param>
                					</xsl:call-template>
                							
                					<tr>
                						<td valign="top" style="width:50mm">
									<p class="default_style"><xsl:value-of select="$Text_Date"/></p>
                						</td>
                						<td valign="top" style="width:60mm">
                							<p class="default_style">
                								<xsl:for-each select="$left//time_of_issue">
                									<xsl:call-template name="display_timestamp">
                										<xsl:with-param name="date">
                											<xsl:value-of select="."/>
                										</xsl:with-param>
                									</xsl:call-template>
                								</xsl:for-each>
                							</p>
                						</td>
                						<td valign="top" style="width:60mm">
                							<p class="default_style">
                								<xsl:for-each select="$right//time_of_issue">
                									<xsl:call-template name="display_timestamp">
                										<xsl:with-param name="date">
                											<xsl:value-of select="."/>
                										</xsl:with-param>
                									</xsl:call-template>
                								</xsl:for-each>
                							</p>
                						</td>
                					</tr>
                					<tr>
                						<td valign="top" style="width:50mm">
									<p class="default_style"><xsl:value-of select="$Text_FileName"/></p>
                						</td>
                						<td valign="top" style="width:60mm">
                							<p class="default_style">
                								<xsl:value-of select="$leftdocdisplayname"/>
                							</p>
                						</td>
                						<td valign="top" style="width:60mm">
                							<p class="default_style">
                								<xsl:value-of select="$rightdocdisplayname"/>
                							</p>
                						</td>
                					</tr>
                				</table>
                				<table>
                					<tr>
                						<td valign="top" style="width:165mm">
									<p class="default_style_ecu"><xsl:value-of select="$Text_AlleUntersch"/></p>
                						</td>
                					</tr>
                				</table>
                				
                				<!-- Create variable containing all distinct ECU ids of the two protocols. -->
                				<xsl:variable name="leftEcuIDs" select="">
                					,<xsl:for-each select="$left//ecu"><xsl:value-of select="substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))"/>,</xsl:for-each>            		             				
                				</xsl:variable>
                				
                				<xsl:variable name="allEcuIDs" select="">
                					<!-- Save all ECU ids from the left list in the variable -->
                					<xsl:for-each select="$left//ecu"><xsl:value-of select="substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))"/>,</xsl:for-each>
                					<!-- Add all ids from the right list that are not allready in the list -->
                					<xsl:for-each select="$right//ecu">
                						<xsl:if test="not(contains($leftEcuIDs, concat(',' ,concat(substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1))), ','))))"><xsl:value-of select="substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))"/>,</xsl:if>
                					</xsl:for-each>       		             				
                				</xsl:variable>

                				<xsl:call-template name="call_diff_functions">
                					<xsl:with-param name="ecu_list" select="$allEcuIDs"/>
                					<xsl:with-param name="functionname">difference_summary</xsl:with-param>
                				</xsl:call-template>
                				
                				<xsl:call-template name="call_diff_functions">
                					<xsl:with-param name="ecu_list" select="$allEcuIDs"/>
                					<xsl:with-param name="functionname">compare_ecu</xsl:with-param>
                				</xsl:call-template>
                			</xsl:otherwise>
                		</xsl:choose>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="call_diff_functions">
		<xsl:param name="ecu_list"/>
		<xsl:param name="functionname"/>
		<xsl:if test="string-length(substring-before($ecu_list,',')) &gt; 0">
			<xsl:choose>
				<xsl:when test="$functionname='difference_summary'">
					<xsl:call-template name="difference_summary">
						<xsl:with-param name="comp_ecu_id">
							<xsl:value-of select="substring-before($ecu_list,',')"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$functionname='compare_ecu'">
					<xsl:call-template name="compare_ecu">
						<xsl:with-param name="comp_ecu_id">
							<xsl:value-of select="substring-before($ecu_list,',')"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
			<xsl:call-template name="call_diff_functions">
				<xsl:with-param name="ecu_list">
					<xsl:value-of select="substring-after($ecu_list,',')"/>
				</xsl:with-param>
				<xsl:with-param name="functionname">
					<xsl:value-of select="$functionname"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="difference_summary">
		<xsl:param name="comp_ecu_id"/>

		<xsl:variable name="result">
			<xsl:for-each select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]">
				<xsl:for-each select="ecu_master[@type='ident']/values">
					<xsl:variable name="left_ecu_id">
						<xsl:value-of select="$comp_ecu_id"/>
					</xsl:variable>
					<xsl:variable name="common_display_name">
						<xsl:value-of select="display_name"/>
					</xsl:variable>
					<xsl:variable name="left_ti_name">
						<xsl:value-of select="ti_name"/>
					</xsl:variable>
					<xsl:variable name="left_display_value">
						<xsl:value-of select="display_value"/>
					</xsl:variable>
					
					<xsl:variable name="right_display_value">
						<xsl:if test="not($left_ti_name='')">
							<xsl:value-of select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_master[@type='ident']/values[ti_name=$left_ti_name]/display_value"/>
						</xsl:if>
						<xsl:if test="$left_ti_name=''">
							<xsl:value-of select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_master[@type='ident']/values[display_name=$common_display_name]/display_value"/>									
						</xsl:if>
					</xsl:variable>

					<xsl:if test="not($left_display_value=$right_display_value)">L</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]">
				<xsl:if test="not($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_master[@type='ident']/values) and ecu_master[@type='ident']/values">R</xsl:if>
			</xsl:for-each>

			<!-- Determine the maximum subsystem number and the number of subsystem entries. -->
			<xsl:variable name="max_subsystem_number">
          		<xsl:call-template name="find-max">
            		<xsl:with-param name="subsystem" select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value"/>
          		</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="numberof_subsystem_number">
            	<xsl:value-of select="count($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value)"/>
			</xsl:variable>
			
			<xsl:choose>
				<xsl:when test="$max_subsystem_number = $numberof_subsystem_number">
					<!-- We found subsystems with sequential numbers.
					In this case only the quantity of subsystems with equal names will be compared. -->

					<xsl:for-each select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem">
						<xsl:variable name="systemname">
							<xsl:value-of select="values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
						</xsl:variable>
						<xsl:variable name="left_counter">
			          		<xsl:call-template name="number-of">
			            		<xsl:with-param name="subsystems" select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem"/>
    	    		    		<xsl:with-param name="systemname" select="$systemname"/>
    	    		    		<xsl:with-param name="counter" select="0"/>
        	  				</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="right_counter">
			          		<xsl:call-template name="number-of">
			            		<xsl:with-param name="subsystems" select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem"/>
    	    		    		<xsl:with-param name="systemname" select="$systemname"/>
    	    		    		<xsl:with-param name="counter" select="0"/>
        	  				</xsl:call-template>
						</xsl:variable>

						<xsl:if test="not($left_counter = $right_counter)">NotEqual</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
	          		<xsl:call-template name="detailedCompare">
	            		<xsl:with-param name="comp_ecu_id" select="$comp_ecu_id"/>
	          		</xsl:call-template>
  				</xsl:otherwise>
			</xsl:choose> 

		</xsl:variable>
		<xsl:if test="not($result='')">
			<p class="default_style">
				<a href="#{$comp_ecu_id}">
					<xsl:text/>
                	<xsl:call-template name="printEcuID">
                		<xsl:with-param name="ecuID" select="$comp_ecu_id"/>
                	</xsl:call-template>
					<xsl:text> - </xsl:text>
					<xsl:choose>
						<xsl:when test="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_master[@type='ident']/values">
							<xsl:value-of select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_name"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_name"/>
						</xsl:otherwise>
					</xsl:choose>
				</a>
			</p>
		</xsl:if>
	</xsl:template>

	<xsl:template name="detailedCompare">
		<xsl:param name="comp_ecu_id"/>
			<xsl:for-each select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem">
				<xsl:variable name="left_subsysid">
					<xsl:value-of select="values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
				</xsl:variable>
				<xsl:variable name="left_subsysodxid">
					<xsl:value-of select="values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value"/>
				</xsl:variable>
				<xsl:for-each select="values">
					<xsl:variable name="left_ecu_id">
						<xsl:value-of select="$comp_ecu_id"/>
					</xsl:variable>
					<xsl:variable name="common_display_name">
						<xsl:value-of select="display_name"/>
					</xsl:variable>
					<xsl:variable name="left_ti_name">
						<xsl:value-of select="ti_name"/>
					</xsl:variable>
					<xsl:variable name="left_display_value">
						<xsl:value-of select="display_value"/>
					</xsl:variable>
					<xsl:variable name="right_display_value">
						<xsl:choose>
							<xsl:when test="not($left_subsysid='') and not($left_subsysid='NOT_SUPPORTED') and not($left_subsysid='NOT_AVAILABLE')">
								<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SYSTEMBEZEICHNUNG and display_value=$left_subsysid]">
									<xsl:if test="position()>1"><xsl:text>, </xsl:text></xsl:if>
									<xsl:if test="not($left_ti_name='')">
										<xsl:value-of select="../values[ti_name=$left_ti_name]/display_value"/>
									</xsl:if>
									<xsl:if test="$left_ti_name=''">
										<xsl:value-of select="../values[display_name=$common_display_name]/display_value"/>
									</xsl:if>									
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG and display_value=$left_subsysodxid]">
									<xsl:if test="position()=1">
										<xsl:if test="not($left_ti_name='')">
											<xsl:value-of select="../values[ti_name=$left_ti_name]/display_value"/>
										</xsl:if>
										<xsl:if test="$left_ti_name=''">
											<xsl:value-of select="../values[display_name=$common_display_name]/display_value"/>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test="not($left_display_value=$right_display_value)">S1</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem">
				<xsl:variable name="right_subsysid">
					<xsl:value-of select="values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
				</xsl:variable>
				<xsl:variable name="right_subsysodxid">
					<xsl:value-of select="values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value"/>
				</xsl:variable>
				<xsl:variable name="right_ecu_id">
					<xsl:value-of select="$comp_ecu_id"/>
				</xsl:variable>
			        <xsl:choose>
					<xsl:when test="not($right_subsysid='') and not($right_subsysid='NOT_SUPPORTED') and not($right_subsysid='NOT_AVAILABLE')">
						<xsl:if test="not($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SYSTEMBEZEICHNUNG and display_value=$right_subsysid])">S2</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="not($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG and display_value=$right_subsysodxid])">S2</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="compare_ecu">
		<xsl:param name="comp_ecu_id"/>
		
		<xsl:variable name="sequential_numbers_error">
       		<xsl:call-template name="sequential_numbers_check">
           		<xsl:with-param name="comp_ecu_id" select="$comp_ecu_id"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:if test="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_master[@type='ident']/values or $right//ecu[ecu_id=$comp_ecu_id]/ecu_master[@type='ident']/values">
			<table>
				<tr>
					<td valign="top" style="width:165mm">
						<p class="default_style_ecu">
							<a name="{$comp_ecu_id}">
								<xsl:value-of select="$Text_Ecu"/><xsl:text>: </xsl:text>
                				<xsl:call-template name="printEcuID">
                					<xsl:with-param name="ecuID" select="$comp_ecu_id"/>
                				</xsl:call-template>  
							</a>
							<xsl:text> - </xsl:text>
							<xsl:choose>
								<xsl:when test="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_master[@type='ident']/values">
									<xsl:value-of select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_name"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_name"/>
								</xsl:otherwise>
							</xsl:choose>
						</p>
					</td>
				</tr>
				<tr>
					<td>
						<table>
							<tr>
								<td valign="top" style="width:50mm">
									<p class="default_style_b"/>
								</td>
								<td valign="top" style="width:60mm">
									<p class="default_style_b"/>
								</td>
								<td valign="top" style="width:60mm">
									<p class="default_style_b"/>
								</td>
							</tr>
							<xsl:for-each select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]">
								<xsl:for-each select="ecu_master[@type='ident']/values">
									<xsl:variable name="left_ecu_id">
										<xsl:value-of select="$comp_ecu_id"/>
									</xsl:variable>
									<xsl:variable name="common_display_name">
										<xsl:value-of select="display_name"/>
									</xsl:variable>
									<xsl:variable name="left_ti_name">
										<xsl:value-of select="ti_name"/>
									</xsl:variable>
									<xsl:variable name="left_display_value">
										<xsl:value-of select="display_value"/>
									</xsl:variable>

									<xsl:variable name="right_display_value">
										<xsl:if test="not($left_ti_name='')">
											<xsl:value-of select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_master[@type='ident']/values[ti_name=$left_ti_name]/display_value"/>
										</xsl:if>
										<xsl:if test="$left_ti_name=''">
											<xsl:value-of select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_master[@type='ident']/values[display_name=$common_display_name]/display_value"/>									
										</xsl:if>
									</xsl:variable>

									<xsl:variable name="format">compstyle<xsl:if test="not($sequential_numbers_error = '') or not($left_display_value=$right_display_value)">N</xsl:if>OK</xsl:variable>
									<tr>
										<td>
											<p class="default_style">
												<xsl:value-of select="$common_display_name"/>
											</p>
										</td>
										<td>
											<p class="{$format}">
												<xsl:value-of select="$left_display_value"/>
											</p>
										</td>
										<td>
											<p class="{$format}">
												<xsl:value-of select="$right_display_value"/>
											</p>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]">
								<xsl:if test="not($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_master[@type='ident']/values)">
									<xsl:for-each select="ecu_master[@type='ident']/values">
										<xsl:variable name="common_display_name">
											<xsl:value-of select="display_name"/>
										</xsl:variable>
										<xsl:variable name="right_display_value">
											<xsl:value-of select="display_value"/>
										</xsl:variable>
										<xsl:variable name="format">compstyleNOK</xsl:variable>
										<tr>
											<td>
												<p class="default_style">
													<xsl:value-of select="$common_display_name"/>
												</p>
											</td>
											<td>
												<p class="{$format}"> </p>
											</td>
											<td>
												<p class="{$format}">
													<xsl:value-of select="$right_display_value"/>
												</p>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:for-each select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem">
			<table>
				<tr>
					<td valign="top" style="width:165mm">
						<p class="default_style_b">
							<xsl:value-of select="$Text_Subsystem"/>
						</p>
					</td>
				</tr>
				<tr>
					<td>
						<table>
							<tr>
								<td valign="top" style="width:50mm">
									<p class="default_style_b"/>
								</td>
								<td valign="top" style="width:60mm">
									<p class="default_style_b"/>
								</td>
								<td valign="top" style="width:60mm">
									<p class="default_style_b"/>
								</td>
							</tr>
							<xsl:variable name="left_subsysid">
								<xsl:value-of select="values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
							</xsl:variable>
							<xsl:variable name="left_subsysodxid"><xsl:value-of select="values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value"/></xsl:variable>
							
							<xsl:for-each select="values">
								<xsl:variable name="left_ecu_id">
									<xsl:value-of select="$comp_ecu_id"/>
								</xsl:variable>
								<xsl:variable name="common_display_name">
									<xsl:value-of select="display_name"/>
								</xsl:variable>
								<xsl:variable name="left_ti_name">
									<xsl:value-of select="ti_name"/>
								</xsl:variable>
								<xsl:variable name="left_display_value">
									<xsl:value-of select="display_value"/>
								</xsl:variable>
								<xsl:variable name="right_display_value">
							        <xsl:choose>
										<xsl:when test="not($left_subsysid='') and not($left_subsysid='NOT_SUPPORTED') and not($left_subsysid='NOT_AVAILABLE')">
										        <xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SYSTEMBEZEICHNUNG and display_value=$left_subsysid]">
												<xsl:if test="position()>1"><xsl:text>, </xsl:text></xsl:if>
												<xsl:if test="not($left_ti_name='')">
													<xsl:value-of select="../values[ti_name=$left_ti_name]/display_value"/>
												</xsl:if>
												<xsl:if test="$left_ti_name=''">
													<xsl:value-of select="../values[display_name=$common_display_name]/display_value"/>
												</xsl:if>
												</xsl:for-each>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$left_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG and display_value=$left_subsysodxid]">
												<xsl:if test="position()=1">
													<xsl:if test="not($left_ti_name='')">
														<xsl:value-of select="../values[ti_name=$left_ti_name]/display_value"/>
													</xsl:if>
													<xsl:if test="$left_ti_name=''">
														<xsl:value-of select="../values[display_name=$common_display_name]/display_value"/>
													</xsl:if>
												</xsl:if>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="format">compstyle<xsl:if test="not($left_display_value = $left_subsysodxid or $left_display_value=$right_display_value)">N</xsl:if>OK</xsl:variable>
								<tr>
									<td>
										<p class="default_style">
											<xsl:value-of select="$common_display_name"/>
										</p>
									</td>
									<td>
										<p class="{$format}">
											<xsl:value-of select="$left_display_value"/>
										</p>
									</td>
									<td>
										<p class="{$format}">
											<xsl:value-of select="$right_display_value"/>
										</p>
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</table>
		</xsl:for-each>

		<!-- Collect the subsystems, that are not in the first (left) file. -->
		<xsl:for-each select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem">
			<xsl:variable name="right_subsysid">
				<xsl:value-of select="values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
			</xsl:variable>
			<xsl:variable name="right_subsysodxid">
				<xsl:value-of select="values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value"/>
			</xsl:variable>
			<xsl:variable name="right_ecu_id">
				<xsl:value-of select="$comp_ecu_id"/>
			</xsl:variable>
			<xsl:variable name="right_system_unique">
		        <xsl:choose>
					<xsl:when test="not($right_subsysid='') and not($right_subsysid='NOT_SUPPORTED') and not($right_subsysid='NOT_AVAILABLE')">
						<xsl:if test="not($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SYSTEMBEZEICHNUNG and display_value=$right_subsysid])">S2</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="not($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]//ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG and display_value=$right_subsysodxid])">S2</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$right_system_unique='S2'">
				<table>
					<tr>
						<td valign="top" style="width:165mm">
							<p class="default_style_b">
								<xsl:value-of select="$Text_Subsystem"/>
							</p>
						</td>
					</tr>
					<tr>
						<td>
							<table>
								<tr>
									<td valign="top" style="width:50mm">
										<p class="default_style_b"/>
									</td>
									<td valign="top" style="width:60mm">
										<p class="default_style_b"/>
									</td>
									<td valign="top" style="width:60mm">
										<p class="default_style_b"/>
									</td>
								</tr>
								<xsl:for-each select="values">
									<xsl:variable name="common_display_name">
										<xsl:value-of select="display_name"/>
									</xsl:variable>
									<xsl:variable name="right_ti_name">
										<xsl:value-of select="ti_name"/>
									</xsl:variable>
									<xsl:variable name="right_display_value">
										<xsl:value-of select="display_value"/>
									</xsl:variable>
									<tr>
										<td>
											<p class="default_style">
												<xsl:value-of select="$common_display_name"/>
											</p>
										</td>
										<td/>
										<td>
											<p class="compstyleNOK">
												<xsl:value-of select="$right_display_value"/>
											</p>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="sequential_numbers_check">
		<xsl:param name="comp_ecu_id"/>
			<!-- Determine the maximum subsystem number and the number of subsystem entries. -->
			<xsl:variable name="max_subsystem_number">
          		<xsl:call-template name="find-max">
            		<xsl:with-param name="subsystem" select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value"/>
          		</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="numberof_subsystem_number">
            	<xsl:value-of select="count($left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem/values[ti_name=$TI_SUBSYSTEMBEZEICHNUNG]/display_value)"/>
			</xsl:variable>
			
			<xsl:choose>
				<xsl:when test="$max_subsystem_number = $numberof_subsystem_number">
					<!-- We found subsystems with sequential numbers.
					In this case only the quantity of subsystems with equal names will be compared. -->

					<xsl:for-each select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem">
						<xsl:variable name="systemname">
							<xsl:value-of select="values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
						</xsl:variable>
						<xsl:variable name="left_counter">
			          		<xsl:call-template name="number-of">
			            		<xsl:with-param name="subsystems" select="$left//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem"/>
    	    		    		<xsl:with-param name="systemname" select="$systemname"/>
    	    		    		<xsl:with-param name="counter" select="0"/>
        	  				</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="right_counter">
			          		<xsl:call-template name="number-of">
			            		<xsl:with-param name="subsystems" select="$right//ecu[substring-after(ecu_id, substring-before(ecu_id, substring(translate(ecu_id, '0', ''), 1, 1)))=$comp_ecu_id]/ecu_subsystem/subsystem"/>
    	    		    		<xsl:with-param name="systemname" select="$systemname"/>
    	    		    		<xsl:with-param name="counter" select="0"/>
        	  				</xsl:call-template>
						</xsl:variable>

						<xsl:if test="not($left_counter = $right_counter)">NotEqual</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
  				</xsl:otherwise>
			</xsl:choose> 
	</xsl:template>

	<xsl:template name="display_timestamp">
		<xsl:param name="date"/>
		<xsl:if test="$date!=''">
			<xsl:value-of select="substring($date,9,2)"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="substring($date,6,2)"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="substring($date,1,4)"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="substring($date,12,12)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="header_comparison">
		<xsl:param name="label" />
		<xsl:param name="left_display_value" />
		<xsl:param name="right_display_value" />
	
		<tr>
			<xsl:variable name="format">compstyle<xsl:if test="not($left_display_value=$right_display_value)">N</xsl:if>OK</xsl:variable>
			<td valign="top" style="width:50mm">
				<p class="default_style"><xsl:value-of select="$label" /></p>
			</td>
			<td valign="top" style="width:60mm">
				<p class="{$format}"><xsl:value-of select="$left_display_value"/></p>
			</td>
			<td valign="top" style="width:60mm">
				<p class="{$format}"><xsl:value-of select="$right_display_value"/></p>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="fileName">
		<xsl:param name="path" />
		<xsl:choose>
			<xsl:when test="contains($path,'\')">
				<xsl:call-template name="fileName"><xsl:with-param name="path" select="substring-after($path,'\')" /></xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($path,'/')">
				<xsl:call-template name="fileName"><xsl:with-param name="path" select="substring-after($path,'/')" /></xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$path" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	  
	<xsl:template name="find-max">
		<xsl:param name="subsystem"/>

      	<!-- The value of the entry in this list. -->
      	<xsl:variable name="this-entry">
	      	<xsl:value-of select="$subsystem[position() = 1]"/>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$subsystem">
				<!-- The maximum value of the entries in this list. -->
				<xsl:variable name="other-entries">
					<xsl:call-template name="find-max">
						<xsl:with-param name="subsystem" select="$subsystem[position() != 1]"/>
					</xsl:call-template>
				</xsl:variable>

				<!-- Return the maximum of this entry and the remaining entries. -->
				<xsl:choose>
					<xsl:when test="$other-entries &gt; $this-entry">
						<xsl:value-of select="$other-entries"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$this-entry"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<!-- We've reached the last entry in the list. -->
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	  
	<xsl:template name="number-of">
		<xsl:param name="subsystems"/>
		<xsl:param name="systemname"/>
		<xsl:param name="counter"/>
	
		<xsl:choose>
			<xsl:when test="$subsystems">
		      	<!-- The value of the entry in this list. -->
		      	<xsl:variable name="current_systemname">
			      	<xsl:value-of select="$subsystems[position() = 1]/values[ti_name=$TI_SYSTEMBEZEICHNUNG]/display_value"/>
				</xsl:variable>

				<xsl:variable name="counter2">
					<xsl:choose>
						<xsl:when test="$current_systemname = $systemname">
							<xsl:value-of select="$counter + 1"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$counter"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
					<xsl:call-template name="number-of">
						<xsl:with-param name="subsystems" select="$subsystems[position() != 1]"/>
						<xsl:with-param name="systemname" select="$systemname"/>
						<xsl:with-param name="counter" select="$counter2"/>
					</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- Array is empty, therefore no increment of the given counter. -->
				<xsl:value-of select="$counter"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Prints the provided ECU ID. The ID is filled up with leading zeros until a length of 4 is reached -->
	<xsl:template name="printEcuID">
		<xsl:param name="ecuID"/>

		<xsl:variable name="zeros" select="'000000'"/>
		<xsl:variable name="numberOfMisingZeros" select="">
        	<xsl:if test="string-length($ecuID) &gt; 3">0</xsl:if>            		   
        	<xsl:if test="string-length($ecuID) &lt; 4">
				<xsl:value-of select="4 - string-length($ecuID)"/>
			</xsl:if>          				
        </xsl:variable>
		<xsl:value-of select="concat(substring($zeros, 1, $numberOfMisingZeros), $ecuID)"/>
	</xsl:template>
</xsl:stylesheet>
