/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.base.bean.IOdisEcuReference;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IMeasurementValueEntryKWP;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IMeasurementValueEntryUDS;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IMeasurementValueTable;
import de.vw.vaudes.diaghook.dto.HookMeasurementValueEntryKWPWrapper;
import de.vw.vaudes.diaghook.dto.HookMeasurementValueEntryUDSWrapper;
import de.vw.vaudes.diaghook.dto.HookMeasurementValueTableWrapper;
import de.vw.vaudes.diaghook.dto.HookOdisEcuReferenceWrapper;
import de.vw.vaudes.diaghook.dto.HookTextIdWrapper;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.xml.object.KWPMesswertTYPE;
import de.vw.vaudes.xml.object.Messwertetabelle;
import de.vw.vaudes.xml.object.ObjektverweisByObjektIdTYPE;
import de.vw.vaudes.xml.object.SWAnzFormatDOM;
import de.vw.vaudes.xml.object.UDSMesswertTYPE;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.object.VglOpDOM;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MeasurementValueTableTransformHelper {
    private static final Log LOGGER = LogFactory.getLog(MeasurementValueTableTransformHelper.class);

    private MeasurementValueTableTransformHelper() {
    }

    public static boolean transformMeasuremetValueTables(IMeasurementValueTable iMeasurementValueTable, VAUDESObjekt vAUDESObjekt) {
        boolean bl = false;
        if (null == vAUDESObjekt.getMesswertetabelle()) {
            LOGGER.error((Object)"Attempt to transform a non measurement value table object to a measurement value table object");
        } else {
            Messwertetabelle messwertetabelle = vAUDESObjekt.getMesswertetabelle();
            if (null != messwertetabelle.getSGReferenz()) {
                iMeasurementValueTable.setEcuReference((IOdisEcuReference)new HookOdisEcuReferenceWrapper(messwertetabelle.getSGReferenz()));
            }
            iMeasurementValueTable.setMvTableKey(vAUDESObjekt.getId());
            if (null != vAUDESObjekt.getAnzeigename()) {
                iMeasurementValueTable.setName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
            } else {
                iMeasurementValueTable.setName(null);
            }
            iMeasurementValueTable.setUds(messwertetabelle.isIstUDS());
            iMeasurementValueTable.setMvTableGfsId(vAUDESObjekt.getSystemname());
            bl = true;
        }
        return bl;
    }

    public static IMeasurementValueTable createMeasurementValueTableObjectFrom(VAUDESObjekt vAUDESObjekt) {
        HookMeasurementValueTableWrapper hookMeasurementValueTableWrapper = null;
        HookMeasurementValueTableWrapper hookMeasurementValueTableWrapper2 = new HookMeasurementValueTableWrapper();
        if (MeasurementValueTableTransformHelper.transformMeasuremetValueTables(hookMeasurementValueTableWrapper2, vAUDESObjekt)) {
            hookMeasurementValueTableWrapper = hookMeasurementValueTableWrapper2;
        }
        return hookMeasurementValueTableWrapper;
    }

    public static List<IMeasurementValueEntryKWP> getKwpEntrysFrom(VAUDESObjekt vAUDESObjekt) {
        ArrayList<IMeasurementValueEntryKWP> arrayList = new ArrayList<IMeasurementValueEntryKWP>();
        if (null == vAUDESObjekt.getMesswertetabelle()) {
            LOGGER.error((Object)"Attempt to transform a non measurement value table object to a measurement value table object");
            return arrayList;
        }
        if (vAUDESObjekt.getMesswertetabelle().isIstUDS()) {
            LOGGER.warn((Object)"Attempt get KWP table entrys from a UDS table ... aborted");
            return arrayList;
        }
        int n = 0;
        for (KWPMesswertTYPE kWPMesswertTYPE : vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert()) {
            try {
                HookMeasurementValueEntryKWPWrapper hookMeasurementValueEntryKWPWrapper = new HookMeasurementValueEntryKWPWrapper();
                MeasurementValueTableTransformHelper.transformKwpEntry(hookMeasurementValueEntryKWPWrapper, kWPMesswertTYPE, vAUDESObjekt);
                hookMeasurementValueEntryKWPWrapper.setMvEntryId(n);
                arrayList.add(hookMeasurementValueEntryKWPWrapper);
                ++n;
            }
            catch (Exception exception) {
                LOGGER.error((Object)"error transforming kwp measurement entries", (Throwable)exception);
            }
        }
        return arrayList;
    }

    private static void transformKwpEntry(IMeasurementValueEntryKWP iMeasurementValueEntryKWP, KWPMesswertTYPE kWPMesswertTYPE, VAUDESObjekt vAUDESObjekt) {
        iMeasurementValueEntryKWP.setMvField(kWPMesswertTYPE.getMwFeld().intValue());
        iMeasurementValueEntryKWP.setMvGroup(kWPMesswertTYPE.getMwGruppe().intValue());
        if (null != kWPMesswertTYPE.getMwMeldung()) {
            iMeasurementValueEntryKWP.setMvMessage(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), kWPMesswertTYPE.getMwMeldung().getStringRef()));
        }
        HookTextIdWrapper hookTextIdWrapper = new HookTextIdWrapper();
        hookTextIdWrapper.setId(kWPMesswertTYPE.getMwAnzNameIdRef().getValue());
        if (kWPMesswertTYPE.getMwAnzNameIdRef().isNotKDRefTab()) {
            hookTextIdWrapper.setSource(vAUDESObjekt.getId());
        } else {
            hookTextIdWrapper.setSource("KDREFTABLE");
        }
        iMeasurementValueEntryKWP.setMvName((ITextId)hookTextIdWrapper);
        iMeasurementValueEntryKWP.setMvTableKey(vAUDESObjekt.getId());
        if (null != kWPMesswertTYPE.getMwSollwertAnz()) {
            iMeasurementValueEntryKWP.setTargetValueType(MeasurementValueTableTransformHelper.transformMeasurmentEntryTargetValueType(kWPMesswertTYPE.getMwSollwertAnz().getAnzTyp()));
            if (null != kWPMesswertTYPE.getMwSollwertAnz().getSWdiskret()) {
                iMeasurementValueEntryKWP.setTargetValue(String.valueOf(kWPMesswertTYPE.getMwSollwertAnz().getSWdiskret().getWertDiskret().intValue()));
                iMeasurementValueEntryKWP.setTargetValueDispFormat(MeasurementValueTableTransformHelper.transformMeasurmentEntryTargetValueDisplayFormat(String.valueOf((Object)kWPMesswertTYPE.getMwSollwertAnz().getSWdiskret().getSWdiskAnzFormat())));
            } else if (null != kWPMesswertTYPE.getMwSollwertAnz().getSWanalog()) {
                iMeasurementValueEntryKWP.setTargetValueMin(String.valueOf(kWPMesswertTYPE.getMwSollwertAnz().getSWanalog().getWertAnalog().getValue()));
                if (null != kWPMesswertTYPE.getMwSollwertAnz().getSWanalog().getSWAnalogMax()) {
                    iMeasurementValueEntryKWP.setTargetValueMax(String.valueOf(kWPMesswertTYPE.getMwSollwertAnz().getSWanalog().getSWAnalogMax()));
                } else {
                    iMeasurementValueEntryKWP.setTargetValueMax(null);
                }
                if (null != kWPMesswertTYPE.getMwSollwertAnz().getSWanalog().getWertAnalog().getVglOP()) {
                    VglOpDOM vglOpDOM = kWPMesswertTYPE.getMwSollwertAnz().getSWanalog().getWertAnalog().getVglOP();
                    boolean bl = vglOpDOM.equals((Object)VglOpDOM.EQ) || vglOpDOM.equals((Object)VglOpDOM.LE) || vglOpDOM.equals((Object)VglOpDOM.GE);
                    iMeasurementValueEntryKWP.setTargetValueMinIncl(bl);
                    iMeasurementValueEntryKWP.setTargetValueMaxIncl(bl);
                }
            } else if (null != kWPMesswertTYPE.getMwSollwertAnz().getSWtext()) {
                iMeasurementValueEntryKWP.setTargetValueText(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), kWPMesswertTYPE.getMwSollwertAnz().getSWtext().getStringRef()));
            }
        }
    }

    private static int transformMeasurmentEntryTargetValueDisplayFormat(String string) {
        int n = 0;
        if (string.equals(SWAnzFormatDOM.INTEGER.toString())) {
            n = 1;
        } else if (string.equals(SWAnzFormatDOM.HEXADEZIMAL.toString())) {
            n = 2;
        } else if (string.equals(SWAnzFormatDOM.BINAER.toString())) {
            n = 3;
        } else if (string.equals(SWAnzFormatDOM.NORMANZEIGE.toString())) {
            n = 4;
        }
        return n;
    }

    private static int transformMeasurmentEntryTargetValueType(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("diskret")) {
            n = 1;
        } else if (string.equalsIgnoreCase("analog")) {
            n = 2;
        } else if (string.equalsIgnoreCase("text")) {
            n = 3;
        }
        return n;
    }

    public static boolean transformMeasurementValueEntryKwp(VAUDESObjekt vAUDESObjekt, int n, IMeasurementValueEntryKWP iMeasurementValueEntryKWP) {
        boolean bl = false;
        if (null == vAUDESObjekt.getMesswertetabelle()) {
            LOGGER.error((Object)"Attempt to transform a non measurement value table object to a measurement value table object");
        } else if (vAUDESObjekt.getMesswertetabelle().isIstUDS()) {
            LOGGER.warn((Object)"Attempt get KWP table entrys from a UDS table ... aborted");
        } else {
            if (null != vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert()) {
                if (n <= vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert().size()) {
                    MeasurementValueTableTransformHelper.transformKwpEntry(iMeasurementValueEntryKWP, vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert().get(n), vAUDESObjekt);
                    iMeasurementValueEntryKWP.setMvEntryId(n);
                } else {
                    LOGGER.warn((Object)("Requested KWP measurement value does not exist. Requested index: " + n + ", Present: " + vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert().size()));
                }
            }
            bl = true;
        }
        return bl;
    }

    public static IMeasurementValueEntryKWP createMeasurementValueEntryKwpFrom(VAUDESObjekt vAUDESObjekt, int n) {
        HookMeasurementValueEntryKWPWrapper hookMeasurementValueEntryKWPWrapper = null;
        HookMeasurementValueEntryKWPWrapper hookMeasurementValueEntryKWPWrapper2 = new HookMeasurementValueEntryKWPWrapper();
        if (MeasurementValueTableTransformHelper.transformMeasurementValueEntryKwp(vAUDESObjekt, n, hookMeasurementValueEntryKWPWrapper2)) {
            hookMeasurementValueEntryKWPWrapper = hookMeasurementValueEntryKWPWrapper2;
        }
        return hookMeasurementValueEntryKWPWrapper;
    }

    public static List<IMeasurementValueEntryUDS> getUdsEntrysFrom(VAUDESObjekt vAUDESObjekt) {
        ArrayList<IMeasurementValueEntryUDS> arrayList = new ArrayList<IMeasurementValueEntryUDS>();
        if (null == vAUDESObjekt.getMesswertetabelle()) {
            LOGGER.error((Object)"Attempt to transform a non measurement value table object to a measurement value table object");
            return arrayList;
        }
        if (!vAUDESObjekt.getMesswertetabelle().isIstUDS()) {
            LOGGER.warn((Object)"Attempt get UDS table entrys from a KWP table ... aborted");
            return arrayList;
        }
        int n = 0;
        for (UDSMesswertTYPE uDSMesswertTYPE : vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert()) {
            HookMeasurementValueEntryUDSWrapper hookMeasurementValueEntryUDSWrapper = new HookMeasurementValueEntryUDSWrapper();
            MeasurementValueTableTransformHelper.transformUdsEntry(hookMeasurementValueEntryUDSWrapper, uDSMesswertTYPE, vAUDESObjekt);
            hookMeasurementValueEntryUDSWrapper.setMvEntryId(n);
            arrayList.add(hookMeasurementValueEntryUDSWrapper);
            ++n;
        }
        return arrayList;
    }

    private static void transformUdsEntry(IMeasurementValueEntryUDS iMeasurementValueEntryUDS, UDSMesswertTYPE uDSMesswertTYPE, VAUDESObjekt vAUDESObjekt) {
        if (null != uDSMesswertTYPE.getMwMeldung()) {
            iMeasurementValueEntryUDS.setMvMessage(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), uDSMesswertTYPE.getMwMeldung().getStringRef()));
        } else {
            iMeasurementValueEntryUDS.setMvMessage(null);
        }
        HookTextIdWrapper hookTextIdWrapper = new HookTextIdWrapper();
        hookTextIdWrapper.setId(uDSMesswertTYPE.getMwAnzNameIdRef().getValue());
        if (uDSMesswertTYPE.getMwAnzNameIdRef().isNotKDRefTab()) {
            hookTextIdWrapper.setSource(vAUDESObjekt.getId());
        } else {
            hookTextIdWrapper.setSource("KDREFTABLE");
        }
        iMeasurementValueEntryUDS.setMvName((ITextId)hookTextIdWrapper);
        iMeasurementValueEntryUDS.setMvTableKey(vAUDESObjekt.getId());
        iMeasurementValueEntryUDS.setOperationName(uDSMesswertTYPE.getMwOperation());
        iMeasurementValueEntryUDS.setOperationParamName(uDSMesswertTYPE.getMwOpParam().getMwOpParamIn().getMwOpParamInName());
        iMeasurementValueEntryUDS.setOperationParamValue(uDSMesswertTYPE.getMwOpParam().getMwOpParamIn().getValue());
        iMeasurementValueEntryUDS.setResultPath(uDSMesswertTYPE.getMwOpParam().getMwOpParamOut());
        iMeasurementValueEntryUDS.setShortName(uDSMesswertTYPE.getMwName());
        if (null != uDSMesswertTYPE.getMwSollwertAnz()) {
            iMeasurementValueEntryUDS.setTargetValueType(MeasurementValueTableTransformHelper.transformMeasurmentEntryTargetValueType(uDSMesswertTYPE.getMwSollwertAnz().getAnzTyp()));
            if (null != uDSMesswertTYPE.getMwSollwertAnz().getSWdiskret()) {
                iMeasurementValueEntryUDS.setTargetValue(String.valueOf(uDSMesswertTYPE.getMwSollwertAnz().getSWdiskret().getWertDiskret().intValue()));
                iMeasurementValueEntryUDS.setTargetValueDispFormat(MeasurementValueTableTransformHelper.transformMeasurmentEntryTargetValueDisplayFormat(String.valueOf((Object)uDSMesswertTYPE.getMwSollwertAnz().getSWdiskret().getSWdiskAnzFormat())));
            } else if (null != uDSMesswertTYPE.getMwSollwertAnz().getSWanalog()) {
                iMeasurementValueEntryUDS.setTargetValueMin(String.valueOf(uDSMesswertTYPE.getMwSollwertAnz().getSWanalog().getWertAnalog().getValue()));
                if (null != uDSMesswertTYPE.getMwSollwertAnz().getSWanalog().getSWAnalogMax()) {
                    iMeasurementValueEntryUDS.setTargetValueMax(String.valueOf(uDSMesswertTYPE.getMwSollwertAnz().getSWanalog().getSWAnalogMax()));
                }
                if (null != uDSMesswertTYPE.getMwSollwertAnz().getSWanalog().getWertAnalog().getVglOP()) {
                    VglOpDOM vglOpDOM = uDSMesswertTYPE.getMwSollwertAnz().getSWanalog().getWertAnalog().getVglOP();
                    boolean bl = vglOpDOM.equals((Object)VglOpDOM.EQ) || vglOpDOM.equals((Object)VglOpDOM.LE) || vglOpDOM.equals((Object)VglOpDOM.GE);
                    iMeasurementValueEntryUDS.setTargetValueMinIncl(bl);
                    iMeasurementValueEntryUDS.setTargetValueMaxIncl(bl);
                }
            } else if (null != uDSMesswertTYPE.getMwSollwertAnz().getSWtext()) {
                iMeasurementValueEntryUDS.setTargetValueText(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), uDSMesswertTYPE.getMwSollwertAnz().getSWtext().getStringRef()));
            }
        }
    }

    public static IMeasurementValueEntryUDS createMeasurementValueEntryUdsFrom(VAUDESObjekt vAUDESObjekt, int n) {
        HookMeasurementValueEntryUDSWrapper hookMeasurementValueEntryUDSWrapper = null;
        HookMeasurementValueEntryUDSWrapper hookMeasurementValueEntryUDSWrapper2 = new HookMeasurementValueEntryUDSWrapper();
        if (MeasurementValueTableTransformHelper.transformMeasurementValueEntryUds(vAUDESObjekt, n, hookMeasurementValueEntryUDSWrapper2)) {
            hookMeasurementValueEntryUDSWrapper = hookMeasurementValueEntryUDSWrapper2;
        }
        return hookMeasurementValueEntryUDSWrapper;
    }

    public static boolean transformMeasurementValueEntryUds(VAUDESObjekt vAUDESObjekt, int n, IMeasurementValueEntryUDS iMeasurementValueEntryUDS) {
        boolean bl = false;
        if (null == vAUDESObjekt.getMesswertetabelle()) {
            LOGGER.error((Object)"Attempt to transform a non measurement value table object to a measurement value table object");
        } else if (!vAUDESObjekt.getMesswertetabelle().isIstUDS()) {
            LOGGER.warn((Object)"Attempt get UDS table entrys from a KWP table ... aborted");
        } else {
            if (null != vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert()) {
                if (n <= vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert().size()) {
                    MeasurementValueTableTransformHelper.transformUdsEntry(iMeasurementValueEntryUDS, vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert().get(n), vAUDESObjekt);
                    iMeasurementValueEntryUDS.setMvEntryId(n);
                } else {
                    LOGGER.warn((Object)("Requested UDS measurement value does not exist. Requested index: " + n + ", Present: " + vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert().size()));
                }
            }
            bl = true;
        }
        return bl;
    }

    public static List<String> getSuspicionsFromMeasurmentTableEntry(VAUDESObjekt vAUDESObjekt, int n) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null == vAUDESObjekt.getMesswertetabelle()) {
            LOGGER.warn((Object)"Attempt to transform a non measurement table object to a measurement table object ... aborting");
        }
        ArrayList<ObjektverweisByObjektIdTYPE> arrayList2 = new ArrayList<ObjektverweisByObjektIdTYPE>();
        if (vAUDESObjekt.getMesswertetabelle().isIstUDS() && vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert().size() > n) {
            object = vAUDESObjekt.getMesswertetabelle().getMesswerte().getUDSMesswert().get(n);
            if (null != ((UDSMesswertTYPE)object).getMwVerdachtsliste()) {
                arrayList2.addAll(((UDSMesswertTYPE)object).getMwVerdachtsliste().getVerdachtsrelation());
            }
        } else if (!vAUDESObjekt.getMesswertetabelle().isIstUDS() && vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert().size() > n && null != ((KWPMesswertTYPE)(object = vAUDESObjekt.getMesswertetabelle().getMesswerte().getKWPMesswert().get(n))).getMwVerdachtsliste()) {
            arrayList2.addAll(((KWPMesswertTYPE)object).getMwVerdachtsliste().getVerdachtsrelation());
        }
        for (ObjektverweisByObjektIdTYPE objektverweisByObjektIdTYPE : arrayList2) {
            arrayList.add(objektverweisByObjektIdTYPE.getObjektRef());
        }
        return arrayList;
    }

    public static void adjustUDSEntryObjects(IMeasurementValueEntryUDS iMeasurementValueEntryUDS, IMeasurementValueEntryUDS iMeasurementValueEntryUDS2) {
        iMeasurementValueEntryUDS.setMvEntryId(iMeasurementValueEntryUDS2.getMvEntryId());
        iMeasurementValueEntryUDS.setMvMessage(iMeasurementValueEntryUDS2.getMvMessage());
        iMeasurementValueEntryUDS.setMvName(iMeasurementValueEntryUDS2.getMvName());
        iMeasurementValueEntryUDS.setMvTableKey(iMeasurementValueEntryUDS2.getMvTableKey());
        iMeasurementValueEntryUDS.setOperationName(iMeasurementValueEntryUDS2.getOperationName());
        iMeasurementValueEntryUDS.setOperationParamName(iMeasurementValueEntryUDS2.getOperationParamName());
        iMeasurementValueEntryUDS.setOperationParamValue(iMeasurementValueEntryUDS2.getOperationParamValue());
        iMeasurementValueEntryUDS.setResultPath(iMeasurementValueEntryUDS2.getResultPath());
        iMeasurementValueEntryUDS.setShortName(iMeasurementValueEntryUDS2.getShortName());
        iMeasurementValueEntryUDS.setTargetValue(iMeasurementValueEntryUDS2.getTargetValue());
        iMeasurementValueEntryUDS.setTargetValueDispFormat(iMeasurementValueEntryUDS2.getTargetValueDispFormat());
        iMeasurementValueEntryUDS.setTargetValueMax(iMeasurementValueEntryUDS2.getTargetValueMax());
        iMeasurementValueEntryUDS.setTargetValueMaxIncl(iMeasurementValueEntryUDS2.isTargetValueMaxIncl());
        iMeasurementValueEntryUDS.setTargetValueMinIncl(iMeasurementValueEntryUDS2.isTargetValueMinIncl());
        iMeasurementValueEntryUDS.setTargetValueMin(iMeasurementValueEntryUDS2.getTargetValueMin());
        iMeasurementValueEntryUDS.setTargetValueText(iMeasurementValueEntryUDS2.getTargetValueText());
        iMeasurementValueEntryUDS.setTargetValueType(iMeasurementValueEntryUDS2.getTargetValueType());
    }

    public static void adjustKWPEntryObjects(IMeasurementValueEntryKWP iMeasurementValueEntryKWP, IMeasurementValueEntryKWP iMeasurementValueEntryKWP2) {
        iMeasurementValueEntryKWP.setMvEntryId(iMeasurementValueEntryKWP2.getMvEntryId());
        iMeasurementValueEntryKWP.setMvField(iMeasurementValueEntryKWP2.getMvField());
        iMeasurementValueEntryKWP.setMvGroup(iMeasurementValueEntryKWP2.getMvGroup());
        iMeasurementValueEntryKWP.setMvMessage(iMeasurementValueEntryKWP2.getMvMessage());
        iMeasurementValueEntryKWP.setMvName(iMeasurementValueEntryKWP2.getMvName());
        iMeasurementValueEntryKWP.setMvTableKey(iMeasurementValueEntryKWP2.getMvTableKey());
        iMeasurementValueEntryKWP.setTargetValue(iMeasurementValueEntryKWP2.getTargetValue());
        iMeasurementValueEntryKWP.setTargetValueDispFormat(iMeasurementValueEntryKWP2.getTargetValueDispFormat());
        iMeasurementValueEntryKWP.setTargetValueMax(iMeasurementValueEntryKWP2.getTargetValueMax());
        iMeasurementValueEntryKWP.setTargetValueMaxIncl(iMeasurementValueEntryKWP2.isTargetValueMaxIncl());
        iMeasurementValueEntryKWP.setTargetValueMin(iMeasurementValueEntryKWP2.getTargetValueMin());
        iMeasurementValueEntryKWP.setTargetValueMinIncl(iMeasurementValueEntryKWP2.isTargetValueMinIncl());
        iMeasurementValueEntryKWP.setTargetValueText(iMeasurementValueEntryKWP2.getTargetValueText());
        iMeasurementValueEntryKWP.setTargetValueType(iMeasurementValueEntryKWP2.getTargetValueType());
    }
}

