/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index.ext.rule;

import de.volkswagen.odis.vaudas.core.utils.StringUtils;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedEquipmentNodeElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.ext.ExtendedDataIndicator;
import de.vw.vaudes.diaghook.index.ext.VaudesObjectDigester;
import de.vw.vaudes.diaghook.index.ext.rule.IExtendedIndicationRule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquipmentNodeExtIndicationRule
implements IExtendedIndicationRule {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    @Override
    public void run(Map<String, IndicatedElement> map) throws URISyntaxException {
        Map<URI, List<IndicatedEquipmentNodeElement>> map2 = this.filterEuipNodes(map);
        VaudesObjectDigester vaudesObjectDigester = new VaudesObjectDigester();
        for (Map.Entry<URI, List<IndicatedEquipmentNodeElement>> entry : map2.entrySet()) {
            try {
                String string;
                if (entry.getValue().get(0).getInstallationIndexFile() == null) {
                    for (IndicatedEquipmentNodeElement indicatedEquipmentNodeElement : entry.getValue()) {
                        string = entry.getKey().toURL().toString() + indicatedEquipmentNodeElement.getFilename();
                        vaudesObjectDigester.run(string);
                        String string2 = vaudesObjectDigester.getKvpsKey();
                        if (StringUtils.isEmpty((String)string2)) continue;
                        ((IndicatedEquipmentNodeElement)ObjectIndicator.getInstance().getObjectById(indicatedEquipmentNodeElement.getObjectId())).setKvpsKey(string2);
                    }
                    continue;
                }
                for (IndicatedEquipmentNodeElement indicatedEquipmentNodeElement : entry.getValue()) {
                    try {
                        vaudesObjectDigester.run(ExtendedDataIndicator.resolveFile(entry.getKey().toURL()), indicatedEquipmentNodeElement.getFilename());
                        string = vaudesObjectDigester.getKvpsKey();
                        if (StringUtils.isEmpty((String)string)) continue;
                        ((IndicatedEquipmentNodeElement)ObjectIndicator.getInstance().getObjectById(indicatedEquipmentNodeElement.getObjectId())).setKvpsKey(string);
                    }
                    catch (Exception exception) {
                        this.fLogger.error((Object)("Error while parsing object " + indicatedEquipmentNodeElement.getFilename()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.fLogger.error((Object)"error during rule execution", (Throwable)exception);
            }
        }
    }

    private Map<URI, List<IndicatedEquipmentNodeElement>> filterEuipNodes(Map<String, IndicatedElement> map) throws URISyntaxException {
        HashMap<URI, List<IndicatedEquipmentNodeElement>> hashMap = new HashMap<URI, List<IndicatedEquipmentNodeElement>>();
        for (Map.Entry<String, IndicatedElement> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof IndicatedEquipmentNodeElement)) continue;
            URI uRI = entry.getValue().getUrl().toURI();
            if (null == hashMap.get(uRI)) {
                ArrayList<IndicatedEquipmentNodeElement> arrayList = new ArrayList<IndicatedEquipmentNodeElement>();
                arrayList.add((IndicatedEquipmentNodeElement)entry.getValue());
                hashMap.put(uRI, arrayList);
                continue;
            }
            ((List)hashMap.get(uRI)).add((IndicatedEquipmentNodeElement)entry.getValue());
        }
        return hashMap;
    }
}

