/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index.db;

import de.volkswagen.odis.vaudas.core.event.brand.Brand;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITranslatedText;
import de.vw.vaudes.diaghook.DiagnosticDataHook;
import de.vw.vaudes.diaghook.da.IDatabaseResult;
import de.vw.vaudes.diaghook.da.IDatabaseService;
import de.vw.vaudes.diaghook.da.IDatabaseTargetCurve;
import de.vw.vaudes.diaghook.da.IDatabaseXmlTemplate;
import de.vw.vaudes.diaghook.da.IDtcRef;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookTranslatedTextWrapper;
import de.vw.vaudes.diaghook.transform.TranslatedTextTransformHelper;
import de.vw.vaudes.diaghook.util.JaxbUtils;
import de.vw.vaudes.xml.object.InhaltdateiDOM;
import de.vw.vaudes.xml.object.TextquelleDOM;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.stringtable.String;
import de.vw.vaudes.xml.stringtable.VAUDESStringTabelle;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseResolver {
    private static final Log LOGGER = LogFactory.getLog((java.lang.String)"de.vw.vaudes.diaghook.index.db.DatabaseResolver");
    private Map<java.lang.String, IDatabaseResult> fObjectIdIndex;
    private Map<java.lang.String, IDatabaseResult> fSystemNameIndex;
    private Map<java.lang.String, IDatabaseResult> fBranchCache;
    private Set<IDatabaseTargetCurve> fTargetCurves;
    private List<IDatabaseTargetCurve> fReleasedTargetCurves;
    private List<IDatabaseTargetCurve> fUnreleasedTargetCurves;
    private boolean fTargetCurvesReceived;
    private Map<java.lang.String, IDatabaseTargetCurve> fTargetCurveSystemnameIndex;
    private Map<java.lang.String, IDatabaseTargetCurve> fTargetCurveIdIndex;
    private Set<java.lang.String> fNegativeCache;
    private Set<java.lang.String> fNegativeBrandList;
    private IDatabaseService fService;
    private Map<Locale, Set<java.lang.String>> fNegativeLocaleObjectMap;
    private Map<java.lang.String, IDatabaseXmlTemplate> fXmlTemplateCache;
    private Set<java.lang.String> fNegativeXmlTemplateCache;
    private boolean fOfflineMode = false;

    private Map<java.lang.String, IDatabaseTargetCurve> getTargetCurveSystemnameIndex() {
        if (null == this.fTargetCurveSystemnameIndex) {
            this.fTargetCurveSystemnameIndex = new HashMap<java.lang.String, IDatabaseTargetCurve>();
        }
        return this.fTargetCurveSystemnameIndex;
    }

    private Map<java.lang.String, IDatabaseTargetCurve> getTargetCurveIdIndex() {
        if (null == this.fTargetCurveIdIndex) {
            this.fTargetCurveIdIndex = new HashMap<java.lang.String, IDatabaseTargetCurve>();
        }
        return this.fTargetCurveIdIndex;
    }

    public static DatabaseResolver getInstance() {
        return Holder.INSTANCE;
    }

    private Set<IDatabaseTargetCurve> getTargetCurves() {
        if (null == this.fTargetCurves) {
            this.fTargetCurves = new HashSet<IDatabaseTargetCurve>();
        }
        return this.fTargetCurves;
    }

    private Map<java.lang.String, IDatabaseResult> getBrandCache() {
        if (null == this.fBranchCache) {
            this.fBranchCache = new HashMap<java.lang.String, IDatabaseResult>();
        }
        return this.fBranchCache;
    }

    private Map<java.lang.String, IDatabaseResult> getVaudesObjektIdCache() {
        if (null == this.fObjectIdIndex) {
            this.fObjectIdIndex = new HashMap<java.lang.String, IDatabaseResult>();
        }
        return this.fObjectIdIndex;
    }

    private Map<Locale, Set<java.lang.String>> getNegativeLocaleObjectMap() {
        if (null == this.fNegativeLocaleObjectMap) {
            this.fNegativeLocaleObjectMap = new HashMap<Locale, Set<java.lang.String>>();
        }
        return this.fNegativeLocaleObjectMap;
    }

    private Map<java.lang.String, IDatabaseResult> getVaudesObjektSystemNameCache() {
        if (null == this.fSystemNameIndex) {
            this.fSystemNameIndex = new HashMap<java.lang.String, IDatabaseResult>();
        }
        return this.fSystemNameIndex;
    }

    private List<IDatabaseTargetCurve> getReleasedTargetCurves() {
        if (null == this.fReleasedTargetCurves) {
            this.fReleasedTargetCurves = new ArrayList<IDatabaseTargetCurve>();
        }
        return this.fReleasedTargetCurves;
    }

    private List<IDatabaseTargetCurve> getUnreleasedTargetCurves() {
        if (null == this.fUnreleasedTargetCurves) {
            this.fUnreleasedTargetCurves = new ArrayList<IDatabaseTargetCurve>();
        }
        return this.fUnreleasedTargetCurves;
    }

    private Set<java.lang.String> getNegativeObjectList() {
        if (null == this.fNegativeCache) {
            this.fNegativeCache = new HashSet<java.lang.String>();
        }
        return this.fNegativeCache;
    }

    private Set<java.lang.String> getNegativeXmlTemplateList() {
        if (null == this.fNegativeXmlTemplateCache) {
            this.fNegativeXmlTemplateCache = new HashSet<java.lang.String>();
        }
        return this.fNegativeXmlTemplateCache;
    }

    public void setService(IDatabaseService iDatabaseService) {
        this.fService = iDatabaseService;
    }

    public boolean isDatabaseAvailable() {
        return null != this.fService;
    }

    private IDatabaseService getService() {
        return this.fService;
    }

    private IDatabaseResult lookupCache(java.lang.String string) {
        IDatabaseResult iDatabaseResult = null;
        if (this.getVaudesObjektIdCache().containsKey(string)) {
            iDatabaseResult = this.getVaudesObjektIdCache().get(string);
        } else if (this.getVaudesObjektSystemNameCache().containsKey(string)) {
            iDatabaseResult = this.getVaudesObjektSystemNameCache().get(string);
        }
        return iDatabaseResult;
    }

    private VAUDESObjekt lookupBrandCache(java.lang.String string) {
        VAUDESObjekt vAUDESObjekt = null;
        if (this.getBrandCache().containsKey(string)) {
            vAUDESObjekt = this.getBrandCache().get(string).getVaudesObjekt();
        }
        return vAUDESObjekt;
    }

    private IDatabaseXmlTemplate lookupXmlTemplateCache(java.lang.String string) {
        IDatabaseXmlTemplate iDatabaseXmlTemplate = null;
        if (this.getXmlTemplateCache().containsKey(string)) {
            iDatabaseXmlTemplate = this.getXmlTemplateCache().get(string);
        }
        return iDatabaseXmlTemplate;
    }

    private Map<java.lang.String, IDatabaseXmlTemplate> getXmlTemplateCache() {
        if (null == this.fXmlTemplateCache) {
            this.fXmlTemplateCache = new HashMap<java.lang.String, IDatabaseXmlTemplate>();
        }
        return this.fXmlTemplateCache;
    }

    private Set<java.lang.String> getNegativeBrandList() {
        if (null == this.fNegativeBrandList) {
            this.fNegativeBrandList = new HashSet<java.lang.String>();
        }
        return this.fNegativeBrandList;
    }

    private IDatabaseTargetCurve lookupTargetCurveCache(java.lang.String string) {
        IDatabaseTargetCurve iDatabaseTargetCurve = null;
        if (this.getTargetCurveIdIndex().containsKey(string)) {
            iDatabaseTargetCurve = this.getTargetCurveIdIndex().get(string);
        } else if (this.getTargetCurveSystemnameIndex().containsKey(string)) {
            iDatabaseTargetCurve = this.getTargetCurveSystemnameIndex().get(string);
        }
        return iDatabaseTargetCurve;
    }

    private IDatabaseTargetCurve lookupTargetCurveCache(java.lang.String string, Locale locale) {
        IDatabaseTargetCurve iDatabaseTargetCurve = null;
        if (this.getTargetCurveIdIndex().containsKey(string)) {
            iDatabaseTargetCurve = this.getTargetCurveIdIndex().get(string);
        } else if (this.getTargetCurveSystemnameIndex().containsKey(string)) {
            iDatabaseTargetCurve = this.getTargetCurveSystemnameIndex().get(string);
        }
        if (null != iDatabaseTargetCurve && !TranslatedTextTransformHelper.isLocaleEqual(locale, iDatabaseTargetCurve.getEditorialLanguage())) {
            iDatabaseTargetCurve = null;
        }
        return iDatabaseTargetCurve;
    }

    private VAUDESObjekt lookupCache(java.lang.String string, Locale locale) {
        VAUDESObjekt vAUDESObjekt = null;
        IDatabaseResult iDatabaseResult = null;
        if (this.getVaudesObjektIdCache().containsKey(string)) {
            iDatabaseResult = this.getVaudesObjektIdCache().get(string);
        } else if (this.getVaudesObjektSystemNameCache().containsKey(string)) {
            iDatabaseResult = this.getVaudesObjektSystemNameCache().get(string);
        }
        if (null != iDatabaseResult && TranslatedTextTransformHelper.isLocaleEqual(locale, iDatabaseResult.getEditorialLanguage())) {
            vAUDESObjekt = iDatabaseResult.getVaudesObjekt();
        }
        return vAUDESObjekt;
    }

    private List<IDatabaseTargetCurve> lookupCache(boolean bl) {
        if (bl) {
            return this.getReleasedTargetCurves();
        }
        return this.getUnreleasedTargetCurves();
    }

    private VAUDESObjekt getFromDB(java.lang.String string, Locale locale) throws NonUniqueResultException {
        VAUDESObjekt vAUDESObjekt = null;
        IDatabaseResult iDatabaseResult = this.lookupCache(string);
        if (null != iDatabaseResult && TranslatedTextTransformHelper.isLocaleEqual(locale, iDatabaseResult.getEditorialLanguage())) {
            return iDatabaseResult.getVaudesObjekt();
        }
        if (!this.isInNegativeCache(string) && !this.isInNegativeLocaleCache(locale, string) && this.isDatabaseAvailable()) {
            IDatabaseResult iDatabaseResult2 = null;
            try {
                iDatabaseResult2 = this.getService().getVaudesObjekt(string, false);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Queried docbase service getVaudesObjekt(" + string + ")"));
                }
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                this.getNegativeObjectList().add(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Add to negative list: " + string));
                }
                throw nonUniqueResultException;
            }
            if (null != iDatabaseResult2) {
                this.getVaudesObjektIdCache().put(string, iDatabaseResult2);
                this.getVaudesObjektIdCache().put(iDatabaseResult2.getObjectId(), iDatabaseResult2);
                this.getVaudesObjektSystemNameCache().put(iDatabaseResult2.getSystemname(), iDatabaseResult2);
                if (TranslatedTextTransformHelper.isLocaleEqual(locale, iDatabaseResult2.getEditorialLanguage()) || TranslatedTextTransformHelper.isLocaleEqual("od_OD", locale) || TextquelleDOM.TEXTLIB.toString().equalsIgnoreCase(iDatabaseResult2.getObjectId()) || "Fahrzeugzustandstexte".equalsIgnoreCase(iDatabaseResult2.getObjectId()) || "Dokkattexte".equalsIgnoreCase(iDatabaseResult2.getObjectId()) || "EfaCodes".equalsIgnoreCase(iDatabaseResult2.getObjectId()) || "AllgSystemtexte".equalsIgnoreCase(iDatabaseResult2.getObjectId()) || "Standardtexte".equalsIgnoreCase(iDatabaseResult2.getObjectId())) {
                    vAUDESObjekt = iDatabaseResult2.getVaudesObjekt();
                } else {
                    this.addToNegativeLocaleObjectList(locale, string);
                }
            } else {
                this.getNegativeObjectList().add(string);
            }
        }
        return vAUDESObjekt;
    }

    private void addToNegativeLocaleObjectList(Locale locale, java.lang.String string) {
        Map<Locale, Set<java.lang.String>> map = this.getNegativeLocaleObjectMap();
        if (map.containsKey(locale)) {
            map.get(locale).add(string);
        } else {
            HashSet<java.lang.String> hashSet = new HashSet<java.lang.String>();
            hashSet.add(string);
            map.put(locale, hashSet);
        }
    }

    private boolean isInNegativeLocaleCache(Locale locale, java.lang.String string) {
        return this.getNegativeLocaleObjectMap().containsKey(locale) && this.getNegativeLocaleObjectMap().get(locale).contains(string);
    }

    private boolean isInNegativeCache(java.lang.String string) {
        return this.getNegativeObjectList().contains(string) || this.getNegativeBrandList().contains(string);
    }

    private boolean isInNegativeXmlTemplateCache(java.lang.String string) {
        return this.getNegativeXmlTemplateList().contains(string);
    }

    public VAUDESObjekt getFromDB(java.lang.String string, boolean bl) throws NonUniqueResultException {
        IDatabaseResult iDatabaseResult;
        VAUDESObjekt vAUDESObjekt = null;
        if (this.isOfflineMode()) {
            return vAUDESObjekt;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DatabaseResolver.getFromDB(" + string + " )"));
        }
        if (null != (iDatabaseResult = this.lookupCache(string))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Get from cache");
            }
            return iDatabaseResult.getVaudesObjekt();
        }
        if (!this.isInNegativeCache(string) && this.isDatabaseAvailable()) {
            IDatabaseResult iDatabaseResult2 = null;
            try {
                iDatabaseResult2 = this.getService().getVaudesObjekt(string, bl);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Queried docbase service getVaudesObjekt(" + string + ")"));
                }
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                this.getNegativeObjectList().add(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Add to negative list: " + string));
                }
                throw nonUniqueResultException;
            }
            if (null != iDatabaseResult2) {
                this.getVaudesObjektIdCache().put(string, iDatabaseResult2);
                this.getVaudesObjektIdCache().put(iDatabaseResult2.getObjectId(), iDatabaseResult2);
                this.getVaudesObjektSystemNameCache().put(iDatabaseResult2.getSystemname(), iDatabaseResult2);
                vAUDESObjekt = iDatabaseResult2.getVaudesObjekt();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Get from docbase");
                }
            } else {
                this.getNegativeObjectList().add(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Add to negative list: " + string));
                }
            }
        }
        return vAUDESObjekt;
    }

    public VAUDESObjekt getEuipmentNodeByKvpsKey(Brand brand) throws NonUniqueResultException {
        VAUDESObjekt vAUDESObjekt;
        if (this.isOfflineMode()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DatabaseResolver.getFromDB(" + brand.getKvpsKey() + " )"));
        }
        if (null != (vAUDESObjekt = this.lookupBrandCache(brand.getKvpsKey()))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Get from cache");
            }
            return vAUDESObjekt;
        }
        IDatabaseResult iDatabaseResult = null;
        if (!this.isInNegativeCache(brand.getKvpsKey()) && this.isDatabaseAvailable()) {
            try {
                iDatabaseResult = this.getService().getEuipmentNodeByKvpsKey(brand.getKvpsKey());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Queried docbase service getEuipmentNodeByKvpsKey(" + brand.getKvpsKey() + ")"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getNegativeBrandList().add(brand.getKvpsKey());
                throw illegalArgumentException;
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                this.getNegativeBrandList().add(brand.getKvpsKey());
                throw nonUniqueResultException;
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception);
            }
            if (null != iDatabaseResult) {
                this.getBrandCache().put(brand.getKvpsKey(), iDatabaseResult);
                vAUDESObjekt = iDatabaseResult.getVaudesObjekt();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Get from docbase");
                }
            } else {
                this.getNegativeBrandList().add(brand.getKvpsKey());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("No Result received for KVPS key " + brand.getKvpsKey()));
                }
            }
        }
        return vAUDESObjekt;
    }

    public List<IDatabaseTargetCurve> getAllTargetCurves() {
        ArrayList<IDatabaseTargetCurve> arrayList = new ArrayList<IDatabaseTargetCurve>();
        if (this.isOfflineMode()) {
            return arrayList;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"DatabaseResolver.getAllTargetCurves()");
        }
        this.getTargetCurves(false);
        arrayList.addAll(this.getReleasedTargetCurves());
        arrayList.addAll(this.getUnreleasedTargetCurves());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDatabaseTargetCurve> getTargetCurves(boolean bl) {
        if (this.isOfflineMode()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DatabaseResolver.getTargetCurves(" + bl + " )"));
        }
        if (this.isDatabaseAvailable() && !this.fTargetCurvesReceived) {
            StopWatch stopWatch = null;
            if (LOGGER.isDebugEnabled()) {
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            ArrayList<IDatabaseTargetCurve> arrayList = new ArrayList<IDatabaseTargetCurve>();
            try {
                arrayList.addAll(this.getService().getAllTargetCurves());
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception);
            }
            finally {
                this.fTargetCurvesReceived = true;
                if (LOGGER.isDebugEnabled()) {
                    stopWatch.stop();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("received " + arrayList.size() + " target curves in " + stopWatch.getTime() / 1000L + "s"));
                    }
                }
            }
            this.getTargetCurves().addAll(arrayList);
            for (IDatabaseTargetCurve iDatabaseTargetCurve : arrayList) {
                this.getTargetCurveSystemnameIndex().put(iDatabaseTargetCurve.getTargetCurveGfsId(), iDatabaseTargetCurve);
                this.getTargetCurveIdIndex().put(iDatabaseTargetCurve.getTargetCurveKey(), iDatabaseTargetCurve);
                if (iDatabaseTargetCurve.getIsReleased()) {
                    this.getReleasedTargetCurves().add(iDatabaseTargetCurve);
                    continue;
                }
                this.getUnreleasedTargetCurves().add(iDatabaseTargetCurve);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"All target curves received, no more queries needed");
            }
        }
        return this.lookupCache(bl);
    }

    public ITranslatedText getTranslatedText(java.lang.String string, Locale locale, ITextId iTextId) throws NonUniqueResultException {
        HookTranslatedTextWrapper hookTranslatedTextWrapper = null;
        if (this.isOfflineMode()) {
            return hookTranslatedTextWrapper;
        }
        if (this.getNegativeObjectList().contains(string) || this.isInNegativeLocaleCache(locale, string)) {
            return hookTranslatedTextWrapper;
        }
        IDatabaseTargetCurve iDatabaseTargetCurve = null;
        VAUDESObjekt vAUDESObjekt = this.lookupCache(string, locale);
        if (null == vAUDESObjekt && null == (iDatabaseTargetCurve = this.lookupTargetCurveCache(string, locale))) {
            vAUDESObjekt = this.getFromDB(string, locale);
        }
        if (null != iDatabaseTargetCurve) {
            hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
            hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)iDatabaseTargetCurve.getEditorialLanguage().toString(), (char)'-', (char)'_'));
            hookTranslatedTextWrapper.setText(iDatabaseTargetCurve.getNameXmlString());
            hookTranslatedTextWrapper.setTextSource(string);
            hookTranslatedTextWrapper.setTextId(iDatabaseTargetCurve.getNameTextId());
        } else if (null != vAUDESObjekt && null != vAUDESObjekt.getDateien()) {
            for (VAUDESObjekt.Dateien.Datei datei : vAUDESObjekt.getDateien().getDatei()) {
                URI uRI;
                java.lang.String string2;
                VAUDESStringTabelle vAUDESStringTabelle;
                if (!datei.isIstUebersetzbar() || !datei.getType().equals((Object)InhaltdateiDOM.TEXTBESTAND) || !TranslatedTextTransformHelper.isLocaleEqual((vAUDESStringTabelle = JaxbUtils.unmarshal(string2 = (uRI = DiagnosticDataHook.getInstance().getDatabaseRessourceLocation()).toString() + datei.getValue(), VAUDESStringTabelle.class)).getSprache(), locale) && !TranslatedTextTransformHelper.isLocaleEqual("od_OD", locale) && !TextquelleDOM.TEXTLIB.toString().equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"Fahrzeugzustandstexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"Dokkattexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"EfaCodes".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"AllgSystemtexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"Standardtexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef())) continue;
                for (String string3 : vAUDESStringTabelle.getString()) {
                    if (!string3.getId().equalsIgnoreCase(iTextId.getId())) continue;
                    hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                    hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)vAUDESStringTabelle.getSprache(), (char)'-', (char)'_'));
                    hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string3));
                    hookTranslatedTextWrapper.setTextSource(string);
                    hookTranslatedTextWrapper.setTextId(string3.getId());
                    break;
                }
                if (null == hookTranslatedTextWrapper) continue;
                break;
            }
        }
        return hookTranslatedTextWrapper;
    }

    public List<ITranslatedText> getTranslatedTexts(java.lang.String string, Locale locale) throws NonUniqueResultException {
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        if (this.isOfflineMode()) {
            return arrayList;
        }
        if (this.getNegativeObjectList().contains(string) || this.isInNegativeLocaleCache(locale, string)) {
            return arrayList;
        }
        IDatabaseTargetCurve iDatabaseTargetCurve = null;
        VAUDESObjekt vAUDESObjekt = this.lookupCache(string, locale);
        if (null == vAUDESObjekt && null == (iDatabaseTargetCurve = this.lookupTargetCurveCache(string, locale))) {
            vAUDESObjekt = this.getFromDB(string, locale);
        }
        if (null != iDatabaseTargetCurve) {
            HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
            hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)iDatabaseTargetCurve.getEditorialLanguage().toString(), (char)'-', (char)'_'));
            hookTranslatedTextWrapper.setText(iDatabaseTargetCurve.getNameXmlString());
            hookTranslatedTextWrapper.setTextSource(string);
            hookTranslatedTextWrapper.setTextId(iDatabaseTargetCurve.getNameTextId());
            arrayList.add(hookTranslatedTextWrapper);
        } else if (null != vAUDESObjekt && null != vAUDESObjekt.getDateien()) {
            for (VAUDESObjekt.Dateien.Datei datei : vAUDESObjekt.getDateien().getDatei()) {
                URI uRI;
                java.lang.String string2;
                VAUDESStringTabelle vAUDESStringTabelle;
                if (!datei.isIstUebersetzbar() || !datei.getType().equals((Object)InhaltdateiDOM.TEXTBESTAND) || !TranslatedTextTransformHelper.isLocaleEqual((vAUDESStringTabelle = JaxbUtils.unmarshal(string2 = (uRI = DiagnosticDataHook.getInstance().getDatabaseRessourceLocation()).toString() + datei.getValue(), VAUDESStringTabelle.class)).getSprache(), locale) && !TranslatedTextTransformHelper.isLocaleEqual("od_OD", locale) && !TextquelleDOM.TEXTLIB.toString().equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"Fahrzeugzustandstexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"Dokkattexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"EfaCodes".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"AllgSystemtexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef()) && !"Standardtexte".equalsIgnoreCase(vAUDESStringTabelle.getObjektRef())) continue;
                for (String string3 : vAUDESStringTabelle.getString()) {
                    HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                    hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)locale.toString(), (char)'-', (char)'_'));
                    hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string3));
                    hookTranslatedTextWrapper.setTextSource(string);
                    hookTranslatedTextWrapper.setTextId(string3.getId());
                    arrayList.add(hookTranslatedTextWrapper);
                }
            }
        }
        return arrayList;
    }

    public List<ITranslatedText> getTranslations(java.lang.String string, java.lang.String string2) throws NonUniqueResultException {
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        if (this.isOfflineMode()) {
            return arrayList;
        }
        if (this.getNegativeObjectList().contains(string)) {
            return arrayList;
        }
        IDatabaseTargetCurve iDatabaseTargetCurve = null;
        VAUDESObjekt vAUDESObjekt = null;
        IDatabaseResult iDatabaseResult = this.lookupCache(string);
        if (null != iDatabaseResult) {
            vAUDESObjekt = iDatabaseResult.getVaudesObjekt();
        }
        if (null == vAUDESObjekt && null == (iDatabaseTargetCurve = this.lookupTargetCurveCache(string))) {
            vAUDESObjekt = this.getFromDB(string, false);
        }
        if (null != iDatabaseTargetCurve) {
            HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
            hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)iDatabaseTargetCurve.getEditorialLanguage().toString(), (char)'-', (char)'_'));
            hookTranslatedTextWrapper.setText(iDatabaseTargetCurve.getNameXmlString());
            hookTranslatedTextWrapper.setTextSource(string);
            hookTranslatedTextWrapper.setTextId(iDatabaseTargetCurve.getNameTextId());
            arrayList.add(hookTranslatedTextWrapper);
        } else if (null != vAUDESObjekt && null != vAUDESObjekt.getDateien()) {
            block0: for (VAUDESObjekt.Dateien.Datei datei : vAUDESObjekt.getDateien().getDatei()) {
                if (!datei.isIstUebersetzbar() || !datei.getType().equals((Object)InhaltdateiDOM.TEXTBESTAND)) continue;
                URI uRI = DiagnosticDataHook.getInstance().getDatabaseRessourceLocation();
                java.lang.String string3 = uRI.toString() + datei.getValue();
                VAUDESStringTabelle vAUDESStringTabelle = JaxbUtils.unmarshal(string3, VAUDESStringTabelle.class);
                for (String string4 : vAUDESStringTabelle.getString()) {
                    if (!string4.getId().equals(string2)) continue;
                    HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                    hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)vAUDESStringTabelle.getSprache(), (char)'-', (char)'_'));
                    hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string4));
                    hookTranslatedTextWrapper.setTextSource(string);
                    hookTranslatedTextWrapper.setTextId(string4.getId());
                    arrayList.add(hookTranslatedTextWrapper);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    public boolean objectCached(java.lang.String string) {
        return !this.isOfflineMode() && (this.getTargetCurveIdIndex().containsKey(string) || this.getTargetCurveSystemnameIndex().containsKey(string) || this.getVaudesObjektIdCache().containsKey(string) || this.getVaudesObjektSystemNameCache().containsKey(string));
    }

    public void reset() {
        this.fTargetCurvesReceived = false;
        this.setOfflineMode(false);
        this.resetCaches();
        if (this.isDatabaseAvailable()) {
            try {
                this.getService().reset();
                LOGGER.info((Object)"Docbase query service was resetted");
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception);
            }
        }
    }

    private void resetCaches() {
        this.getBrandCache().clear();
        this.getNegativeObjectList().clear();
        this.getNegativeBrandList().clear();
        this.getReleasedTargetCurves().clear();
        this.getTargetCurveIdIndex().clear();
        this.getTargetCurves().clear();
        this.getTargetCurveSystemnameIndex().clear();
        this.getUnreleasedTargetCurves().clear();
        this.getVaudesObjektIdCache().clear();
        this.getVaudesObjektSystemNameCache().clear();
        this.getNegativeXmlTemplateList().clear();
        this.getXmlTemplateCache().clear();
    }

    public IDatabaseXmlTemplate getXmlTemplate(java.lang.String string) {
        IDatabaseXmlTemplate iDatabaseXmlTemplate;
        if (this.isOfflineMode()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DatabaseResolver.getXmlTemplate(" + string + " )"));
        }
        if (null != (iDatabaseXmlTemplate = this.lookupXmlTemplateCache(string))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Get from cache");
            }
            return iDatabaseXmlTemplate;
        }
        if (!this.isInNegativeXmlTemplateCache(string) && this.isDatabaseAvailable()) {
            block12: {
                try {
                    iDatabaseXmlTemplate = this.getService().getXmlTemplate(string);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Queried docbase service getXmlTemplate(" + string + ")"));
                    }
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    this.getNegativeXmlTemplateList().add(string);
                    if (!LOGGER.isDebugEnabled()) break block12;
                    LOGGER.debug((Object)("Add to negative list: " + string));
                }
            }
            if (null != iDatabaseXmlTemplate) {
                this.getXmlTemplateCache().put(string, iDatabaseXmlTemplate);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Get from docbase");
                }
            } else {
                this.getNegativeXmlTemplateList().add(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Add to negative list: " + string));
                }
            }
        }
        return iDatabaseXmlTemplate;
    }

    public void createCache(java.lang.String string) {
        if (!this.isOfflineMode()) {
            this.getService().createCache(string);
        }
    }

    public void setOfflineMode(boolean bl) {
        this.fOfflineMode = bl;
    }

    protected boolean isOfflineMode() {
        return this.fOfflineMode || LOGGER.isDebugEnabled() && "true".equals(System.getProperty("de.vw.vaudes.fte.debug.fteDebugForceOffline"));
    }

    public void setBaseline(java.lang.String string, java.lang.String string2, java.lang.String string3) {
        this.getService().setBaseline(string, string2, string3);
    }

    public void setBrand(java.lang.String string) {
        this.getService().setBrand(string);
    }

    public List<IDtcRef> getDtcs(java.lang.String string, java.lang.String string2) {
        return this.getService().getDtcs(string, string2);
    }

    private static class Holder {
        private static final DatabaseResolver INSTANCE = new DatabaseResolver();

        private Holder() {
        }
    }
}

