/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.core.exception.ids.Topology;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaConditionKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaErrorObjectKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaErrorTypeKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaLocationKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaCondition;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaErrorObject;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaErrorType;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaLocation;
import de.volkswagen.odis.vaudas.domainmodel.efa.factory.IEfaDataFactory;
import de.vw.vaudes.diaghook.transform.EfaTransformHelper;
import de.vw.vaudes.diaghook.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EfaDataFactoryImpl
implements IEfaDataFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public List<IEfaLocation> getAllEfaLocations(List<IEfaLocation> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getAllEfaLocations(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaLocation>();
        }
        try {
            Set<IEfaLocation> set = EfaTransformHelper.getAllEfaLocations();
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa Location from Index: " + set));
            }
            EfaTransformHelper.mergeEfaLocations(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)"error during efa transformation", (Throwable)exception);
        }
        return list;
    }

    public List<IEfaCondition> getChildrenForCondition(EfaConditionKey efaConditionKey, List<IEfaCondition> list) throws OdisBaseException {
        Validate.notNull(efaConditionKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getChildrenForCondition(" + efaConditionKey + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaCondition>();
        }
        try {
            Set<IEfaCondition> set = EfaTransformHelper.getAllEfaConditionsForParentKey(efaConditionKey.getValue());
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa Conditions from Index: " + set));
            }
            EfaTransformHelper.mergeEfaConditions(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)"error during efa transformation", (Throwable)exception);
        }
        return list;
    }

    public List<IEfaErrorObject> getChildrenForErrorObject(EfaErrorObjectKey efaErrorObjectKey, List<IEfaErrorObject> list) throws OdisBaseException {
        Validate.notNull(efaErrorObjectKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getChildrenForErrorObject(" + efaErrorObjectKey + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaErrorObject>();
        }
        try {
            Set<IEfaErrorObject> set = EfaTransformHelper.getAllEfaErrorObjectsForParentId(efaErrorObjectKey.getValue());
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa errors objects from Index: " + set));
            }
            EfaTransformHelper.mergeEfaErrorObjects(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)"error during efa transformation", (Throwable)exception);
        }
        return list;
    }

    public List<IEfaErrorType> getChildrenForErrorType(EfaErrorTypeKey efaErrorTypeKey, List<IEfaErrorType> list) throws OdisBaseException {
        Validate.notNull(efaErrorTypeKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getChildrenForErrorType(" + efaErrorTypeKey + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaErrorType>();
        }
        try {
            Set<IEfaErrorType> set = EfaTransformHelper.getEfaErrorTypesForEfaErrorTypeParentId(efaErrorTypeKey.getValue());
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa error types from Index: " + set));
            }
            EfaTransformHelper.mergeEfaTypes(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)"error during efa transformation", (Throwable)exception);
        }
        return list;
    }

    public IEfaCondition getEfaCondition(EfaConditionKey efaConditionKey, IEfaCondition iEfaCondition) throws OdisBaseException {
        Validate.notNull(efaConditionKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaCondition(" + efaConditionKey + ", " + iEfaCondition + ")"));
        }
        boolean bl = iEfaCondition != null;
        IEfaCondition iEfaCondition2 = EfaTransformHelper.getEfaConditionForId(efaConditionKey.getValue());
        if (iEfaCondition2 == null) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iEfaCondition));
                }
                return iEfaCondition;
            }
            throw new OdisBaseException("Can't find efa condition for key " + efaConditionKey.getValue(), Topology.database().dbReadFailed());
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
            this.fLogger.debug((Object)("return new " + iEfaCondition2));
        }
        return iEfaCondition2;
    }

    public List<IEfaCondition> getEfaConditionsForErrorObject(EfaErrorObjectKey efaErrorObjectKey, List<IEfaCondition> list) throws OdisBaseException {
        Validate.notNull(efaErrorObjectKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaConditionsForErrorObject(" + efaErrorObjectKey + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaCondition>();
        }
        try {
            Set<IEfaCondition> set = EfaTransformHelper.getEfaConditionsForEfaErrorObjectId(efaErrorObjectKey.getValue());
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa conditions from Index: " + set));
            }
            EfaTransformHelper.mergeEfaConditions(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming efa object " + efaErrorObjectKey.getValue()), (Throwable)exception);
        }
        return list;
    }

    public IEfaErrorObject getEfaErrorObject(EfaErrorObjectKey efaErrorObjectKey, IEfaErrorObject iEfaErrorObject) throws OdisBaseException {
        Validate.notNull(efaErrorObjectKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaErrorObject(" + efaErrorObjectKey + ", " + iEfaErrorObject + ")"));
        }
        boolean bl = iEfaErrorObject != null;
        IEfaErrorObject iEfaErrorObject2 = EfaTransformHelper.getEfaErrorObjectForId(efaErrorObjectKey.getValue());
        if (iEfaErrorObject2 == null) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iEfaErrorObject));
                }
                return iEfaErrorObject;
            }
            throw new OdisBaseException("Can't find efa location for key " + efaErrorObjectKey.getValue(), Topology.database().dbReadFailed());
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
            this.fLogger.debug((Object)("return new " + iEfaErrorObject2));
        }
        return iEfaErrorObject2;
    }

    public IEfaErrorType getEfaErrorType(EfaErrorTypeKey efaErrorTypeKey, IEfaErrorType iEfaErrorType) throws OdisBaseException {
        Validate.notNull(efaErrorTypeKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaErrorType(" + efaErrorTypeKey + ", " + iEfaErrorType + ")"));
        }
        boolean bl = iEfaErrorType != null;
        IEfaErrorType iEfaErrorType2 = EfaTransformHelper.getEfaErrorTypeForId(efaErrorTypeKey.getValue());
        if (iEfaErrorType2 == null) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iEfaErrorType));
                }
                return iEfaErrorType;
            }
            throw new OdisBaseException("Can't find efa error type for key " + efaErrorTypeKey.getValue(), Topology.database().dbReadFailed());
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
            this.fLogger.debug((Object)("return new " + iEfaErrorType2));
        }
        return iEfaErrorType2;
    }

    public List<IEfaErrorType> getEfaErrorTypesForErrorObject(EfaErrorObjectKey efaErrorObjectKey, List<IEfaErrorType> list) throws OdisBaseException {
        Validate.notNull(efaErrorObjectKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaErrorTypesForErrorObject(" + efaErrorObjectKey + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaErrorType>();
        }
        try {
            Set<IEfaErrorType> set = EfaTransformHelper.getAllEfaErrorTypesForEfaErrorId(efaErrorObjectKey.getValue());
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa error types from Index: " + set));
            }
            EfaTransformHelper.mergeEfaTypes(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming efa object " + efaErrorObjectKey.getValue()), (Throwable)exception);
        }
        return list;
    }

    public IEfaLocation getEfaLocation(EfaLocationKey efaLocationKey, IEfaLocation iEfaLocation) throws OdisBaseException {
        Validate.notNull(efaLocationKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaLocation(" + efaLocationKey + ", " + iEfaLocation + ")"));
        }
        boolean bl = iEfaLocation != null;
        IEfaLocation iEfaLocation2 = EfaTransformHelper.getEfaLocationForId(efaLocationKey.getValue());
        if (iEfaLocation2 == null) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iEfaLocation));
                }
                return iEfaLocation;
            }
            throw new OdisBaseException("Can't find efa location for key " + efaLocationKey.getValue(), Topology.database().dbReadFailed());
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
            this.fLogger.debug((Object)("return new " + iEfaLocation2));
        }
        return iEfaLocation2;
    }

    public List<IEfaLocation> getEfaLocationsForErrorObject(EfaErrorObjectKey efaErrorObjectKey, List<IEfaLocation> list) throws OdisBaseException {
        Validate.notNull(efaErrorObjectKey);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEfaLocationsForErrorObject(" + efaErrorObjectKey + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaLocation>();
        }
        try {
            Set<IEfaLocation> set = EfaTransformHelper.getEfaLocationsForEfaErrorObjectId(efaErrorObjectKey.getValue());
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa locations from Index: " + set));
            }
            EfaTransformHelper.mergeEfaLocations(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error during transformation of efa object " + efaErrorObjectKey.getValue()), (Throwable)exception);
        }
        return list;
    }

    public List<IEfaCondition> getTopLevelConditions(List<IEfaCondition> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTopLevelConditions(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaCondition>();
        }
        try {
            Set<IEfaCondition> set = EfaTransformHelper.getTopLevelEfaConditions();
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa conditions from Index: " + set));
            }
            EfaTransformHelper.mergeEfaConditions(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)exception);
        }
        return list;
    }

    public List<IEfaErrorObject> getTopLevelErrorObjects(List<IEfaErrorObject> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTopLevelErrorObjects(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaErrorObject>();
        }
        try {
            Set<IEfaErrorObject> set = EfaTransformHelper.getEfaTopLevelErrorObjects();
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa error objects from Index: " + set));
            }
            EfaTransformHelper.mergeEfaErrorObjects(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)exception);
        }
        return list;
    }

    public List<IEfaErrorType> getTopLevelErrorTypes(List<IEfaErrorType> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTopLevelErrorTypes(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEfaErrorType>();
        }
        try {
            Set<IEfaErrorType> set = EfaTransformHelper.getEfaTopLevelErrorTypes();
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("Efa error types from Index: " + set));
            }
            EfaTransformHelper.mergeEfaTypes(list, set);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
        }
        catch (Exception exception) {
            this.fLogger.error((Object)exception);
        }
        return list;
    }
}

